/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mana;

import forge.card.MagicColor;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;

public class Mana {
    private byte color;
    private Card sourceCard = null;
    private AbilityManaPart manaAbility = null;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.color;
        result = 31 * result + (this.manaAbility == null ? 0 : this.manaAbility.hashCode());
        result = 31 * result + (this.sourceCard == null ? 0 : this.sourceCard.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        AbilityManaPart mp2;
        if (!(other instanceof Mana)) {
            return false;
        }
        Mana m22 = (Mana)other;
        if (this.color != m22.color) {
            return false;
        }
        AbilityManaPart mp = this.getManaAbility();
        if (mp == null != ((mp2 = m22.getManaAbility()) == null)) {
            return false;
        }
        if (!this.sourceCard.equals(m22.sourceCard) && mp != null) {
            if (this.addsKeywords(null) != m22.addsKeywords(null)) {
                return false;
            }
            if (this.addsCounters(null) != m22.addsCounters(null)) {
                return false;
            }
            if (mp.isCannotCounterPaidWith() != mp2.isCannotCounterPaidWith()) {
                return false;
            }
            if (mp.getTriggersWhenSpent() != mp2.getTriggersWhenSpent()) {
                return false;
            }
            if (mp.isPersistentMana() != mp2.isPersistentMana()) {
                return false;
            }
        }
        return mp == mp2 || mp.getManaRestrictions().equals(mp2.getManaRestrictions()) && mp.getExtraManaRestriction().equals(mp2.getExtraManaRestriction());
    }

    public Mana(byte color, Card source, AbilityManaPart manaAbility) {
        this.color = color;
        this.manaAbility = manaAbility;
        this.sourceCard = source.isInPlay() ? CardCopyService.getLKICopy(source) : source.getGame().getChangeZoneLKIInfo(source);
    }

    public final String toString() {
        return MagicColor.toShortString(this.color);
    }

    public final boolean isSnow() {
        return this.sourceCard.isSnow();
    }

    public final boolean isRestricted() {
        return this.manaAbility != null && (!this.manaAbility.getManaRestrictions().isEmpty() || !this.manaAbility.getExtraManaRestriction().isEmpty());
    }

    public final boolean addsNoCounterMagic(SpellAbility saBeingPaid) {
        return this.manaAbility != null && this.manaAbility.cannotCounterPaidWith(saBeingPaid);
    }

    public final boolean addsCounters(SpellAbility saBeingPaid) {
        return this.manaAbility != null && this.manaAbility.addsCounters(saBeingPaid);
    }

    public final boolean addsKeywords(SpellAbility saBeingPaid) {
        return this.manaAbility != null && this.manaAbility.addKeywords(saBeingPaid);
    }

    public final boolean addsKeywordsType() {
        return this.manaAbility != null && this.manaAbility.getAddsKeywordsType() != null;
    }

    public final boolean addsKeywordsUntil() {
        return this.manaAbility != null && this.manaAbility.getAddsKeywordsUntil() != null;
    }

    public final String getAddedKeywords() {
        return this.manaAbility.getKeywords();
    }

    public final boolean triggersWhenSpent() {
        return this.manaAbility != null && this.manaAbility.getTriggersWhenSpent();
    }

    public final byte getColor() {
        return this.color;
    }

    public final Card getSourceCard() {
        return this.sourceCard;
    }

    public final AbilityManaPart getManaAbility() {
        return this.manaAbility;
    }

    public boolean isColorless() {
        return this.color == 32;
    }
}

