/*
 * Decompiled with CFR 0.152.
 */
package forge.game.keyword;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.TriggerReplacementBase;
import forge.game.card.Card;
import forge.game.card.CardFactoryUtil;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.player.PlayerFactoryUtil;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.util.Lang;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class KeywordInstance<T extends KeywordInstance<?>>
implements KeywordInterface {
    private Card hostCard = null;
    private boolean intrinsic = false;
    private Keyword keyword;
    private String original;
    private StaticAbility st = null;
    private long idx = -1L;
    private List<Trigger> triggers = Lists.newArrayList();
    private List<ReplacementEffect> replacements = Lists.newArrayList();
    private List<SpellAbility> abilities = Lists.newArrayList();
    private List<StaticAbility> staticAbilities = Lists.newArrayList();

    @Override
    public String getOriginal() {
        return this.original;
    }

    @Override
    public Keyword getKeyword() {
        return this.keyword;
    }

    @Override
    public String getReminderText() {
        String result = this.formatReminderText(this.keyword.reminderText);
        Matcher m4 = Pattern.compile("\\{(\\w+):(.+?)\\}").matcher(result);
        StringBuffer sb = new StringBuffer();
        while (m4.find()) {
            m4.appendReplacement(sb, Lang.nounWithNumeralExceptOne(m4.group(1), m4.group(2)));
        }
        m4.appendTail(sb);
        return sb.toString();
    }

    @Override
    public int getAmount() {
        return 1;
    }

    protected void initialize(String original0, Keyword keyword0, String details) {
        this.original = original0;
        this.keyword = keyword0;
        this.parse(details);
    }

    protected abstract void parse(String var1);

    protected abstract String formatReminderText(String var1);

    @Override
    public final void createTraits(Card host, boolean intrinsic) {
        this.createTraits(host, intrinsic, false);
    }

    @Override
    public final void createTraits(Card host, boolean intrinsic, boolean clear) {
        this.hostCard = host;
        this.intrinsic = intrinsic;
        if (clear) {
            this.triggers.clear();
            this.replacements.clear();
            this.abilities.clear();
            this.staticAbilities.clear();
        }
        try {
            String msg = "KeywordInstance:createTraits: make Traits for Keyword";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Card", host.getName());
            bread.setData("Keyword", this.original);
            Sentry.addBreadcrumb(bread);
            Sentry.setExtra("Card", host.getName());
            Sentry.setExtra("Keyword", this.original);
            CardFactoryUtil.addTriggerAbility(this, host, intrinsic);
            CardFactoryUtil.addReplacementEffect(this, host.getCurrentState(), intrinsic);
            CardFactoryUtil.addSpellAbility(this, host.getCurrentState(), intrinsic);
            CardFactoryUtil.addStaticAbility(this, host.getCurrentState(), intrinsic);
        }
        catch (Exception e) {
            String msg = "KeywordInstance:createTraits: failed Traits for Keyword";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Card", host.getName());
            bread.setData("Keyword", this.original);
            Sentry.addBreadcrumb(bread);
            throw new RuntimeException("Error in Keyword " + this.original + " for card " + host.getName(), e);
        }
        finally {
            Sentry.removeExtra("Card");
            Sentry.removeExtra("Keyword");
        }
    }

    @Override
    public void createTraits(Player player) {
        this.createTraits(player, false);
    }

    @Override
    public void createTraits(Player player, boolean clear) {
        if (clear) {
            this.triggers.clear();
            this.replacements.clear();
            this.abilities.clear();
            this.staticAbilities.clear();
        }
        try {
            String msg = "KeywordInstance:createTraits: make Traits for Keyword";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Player", player.getName());
            bread.setData("Keyword", this.original);
            Sentry.addBreadcrumb(bread);
            Sentry.setExtra("Player", player.getName());
            Sentry.setExtra("Keyword", this.original);
            PlayerFactoryUtil.addTriggerAbility(this, player);
            PlayerFactoryUtil.addReplacementEffect(this, player);
            PlayerFactoryUtil.addSpellAbility(this, player);
            PlayerFactoryUtil.addStaticAbility(this, player);
        }
        catch (Exception e) {
            String msg = "KeywordInstance:createTraits: failed Traits for Keyword";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Player", player.getName());
            bread.setData("Keyword", this.original);
            Sentry.addBreadcrumb(bread);
            throw new RuntimeException("Error in Keyword " + this.original + " for player " + player.getName(), e);
        }
        finally {
            Sentry.removeExtra("Player");
            Sentry.removeExtra("Keyword");
        }
    }

    @Override
    public final void addTrigger(Trigger trg) {
        trg.setKeyword(this);
        this.triggers.add(trg);
    }

    @Override
    public final void addReplacement(ReplacementEffect trg) {
        trg.setKeyword(this);
        this.replacements.add(trg);
    }

    @Override
    public final void addSpellAbility(SpellAbility s2) {
        s2.setKeyword(this);
        this.abilities.add(s2);
    }

    @Override
    public final void addStaticAbility(StaticAbility st) {
        st.setKeyword(this);
        this.staticAbilities.add(st);
    }

    @Override
    public Collection<Trigger> getTriggers() {
        return this.triggers;
    }

    @Override
    public Collection<ReplacementEffect> getReplacements() {
        return this.replacements;
    }

    @Override
    public Collection<SpellAbility> getAbilities() {
        return this.abilities;
    }

    @Override
    public Collection<StaticAbility> getStaticAbilities() {
        return this.staticAbilities;
    }

    @Override
    public KeywordInterface copy(Card host, boolean lki) {
        try {
            CardTraitBase copy;
            KeywordInstance result = (KeywordInstance)super.clone();
            result.hostCard = host;
            result.abilities = Lists.newArrayList();
            for (SpellAbility spellAbility : this.abilities) {
                copy = spellAbility.copy(host, lki);
                ((SpellAbility)copy).setKeyword(result);
                result.abilities.add((SpellAbility)copy);
            }
            result.triggers = Lists.newArrayList();
            for (Trigger trigger : this.triggers) {
                copy = trigger.copy(host, lki);
                ((TriggerReplacementBase)copy).setKeyword(result);
                result.triggers.add((Trigger)copy);
            }
            result.replacements = Lists.newArrayList();
            for (ReplacementEffect replacementEffect : this.replacements) {
                copy = replacementEffect.copy(host, lki);
                ((TriggerReplacementBase)copy).setKeyword(result);
                result.replacements.add((ReplacementEffect)copy);
            }
            result.staticAbilities = Lists.newArrayList();
            for (StaticAbility staticAbility : this.staticAbilities) {
                copy = staticAbility.copy(host, lki);
                copy.setKeyword(result);
                result.staticAbilities.add((StaticAbility)copy);
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException("KeywordInstance : clone() error", ex);
        }
    }

    public String toString() {
        return this.getOriginal();
    }

    @Override
    public boolean redundant(Collection<KeywordInterface> list) {
        if (!this.keyword.isMultipleRedundant) {
            return false;
        }
        for (KeywordInterface i : list) {
            if (!i.getOriginal().equals(this.getOriginal())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Card getHostCard() {
        return this.hostCard;
    }

    @Override
    public void setHostCard(Card host) {
        this.hostCard = host;
        for (SpellAbility spellAbility : this.abilities) {
            spellAbility.setHostCard(host);
        }
        for (Trigger trigger : this.triggers) {
            trigger.setHostCard(host);
        }
        for (ReplacementEffect replacementEffect : this.replacements) {
            replacementEffect.setHostCard(host);
        }
        for (StaticAbility staticAbility : this.staticAbilities) {
            staticAbility.setHostCard(host);
        }
    }

    @Override
    public boolean isIntrinsic() {
        return this.intrinsic;
    }

    @Override
    public void setIntrinsic(boolean value) {
        this.intrinsic = value;
        for (SpellAbility spellAbility : this.abilities) {
            spellAbility.setIntrinsic(value);
        }
        for (Trigger trigger : this.triggers) {
            trigger.setIntrinsic(value);
        }
        for (ReplacementEffect replacementEffect : this.replacements) {
            replacementEffect.setIntrinsic(value);
        }
        for (StaticAbility staticAbility : this.staticAbilities) {
            staticAbility.setIntrinsic(value);
        }
    }

    @Override
    public StaticAbility getStatic() {
        return this.st;
    }

    @Override
    public void setStatic(StaticAbility st) {
        this.st = st;
    }

    @Override
    public long getIdx() {
        return this.idx;
    }

    @Override
    public void setIdx(long i) {
        this.idx = i;
    }
}

