/*
 * Decompiled with CFR 0.152.
 */
package forge.game.event;

import forge.game.event.EventValueChangeType;
import forge.game.event.GameEvent;
import forge.game.event.IGameEventVisitor;
import forge.game.mana.Mana;
import forge.game.player.Player;
import forge.util.Lang;
import forge.util.TextUtil;

public class GameEventManaPool
extends GameEvent {
    public final Player player;
    public final EventValueChangeType mode;
    public final Mana mana;

    public GameEventManaPool(Player owner, EventValueChangeType changeMode, Mana mana) {
        this.mana = mana;
        this.player = owner;
        this.mode = changeMode;
    }

    @Override
    public <T> T visit(IGameEventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return TextUtil.concatWithSpace(Lang.getInstance().getPossesive(this.player.getName()), "mana pool", this.mode.toString(), "-", TextUtil.addSuffix(this.mana.toString(), " "));
    }
}

