/*
 * Decompiled with CFR 0.152.
 */
package forge.game.event;

import com.google.common.collect.Iterables;
import forge.game.card.Card;
import forge.game.event.GameEvent;
import forge.game.event.IGameEventVisitor;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class GameEventCardStatsChanged
extends GameEvent {
    public final Collection<Card> cards;
    public boolean transform = false;

    public GameEventCardStatsChanged(Card affected) {
        this(affected, false);
    }

    public GameEventCardStatsChanged(Card affected, boolean isTransform) {
        this.cards = Arrays.asList(affected);
        this.transform = false;
    }

    public GameEventCardStatsChanged(Collection<Card> affected) {
        this.cards = affected;
    }

    @Override
    public <T> T visit(IGameEventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        Card card = Iterables.getFirst(this.cards, null);
        if (null == card) {
            return "Card state changes: (empty list)";
        }
        if (this.cards.size() == 1) {
            return "Card state changes: " + card.getName() + " (" + StringUtils.join(card.getType(), ' ') + ") " + card.getNetPower() + "/" + card.getNetToughness();
        }
        return "Card state changes: " + card.getName() + " (" + StringUtils.join(card.getType(), ' ') + ") " + card.getNetPower() + "/" + card.getNetToughness() + " and " + (this.cards.size() - 1) + " more";
    }
}

