/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.EnumMap;
import java.util.HashMap;

public class CostUntapType
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    public final boolean canUntapSource;

    public CostUntapType(String amount, String type, String description, boolean hasUntapInPrice) {
        super(amount, type, description);
        this.canUntapSource = !hasUntapInPrice;
    }

    @Override
    public int paymentOrder() {
        return 18;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isRenewable() {
        return true;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Untap ");
        Integer i = this.convertAmount();
        String desc = this.getDescriptiveType();
        sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), " tapped " + desc));
        if (this.getType().contains("OppCtrl")) {
            sb.append(" an opponent controls");
        } else if (this.getType().contains("YouCtrl")) {
            sb.append(" you control");
        }
        return sb.toString();
    }

    @Override
    public final void refund(Card source) {
        for (Card c : this.getCardList()) {
            c.setTapped(true);
        }
        this.resetLists();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Player activator = ability.getActivatingPlayer();
        Card source = ability.getHostCard();
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)activator.getGame().getCardsIn(ZoneType.Battlefield), this.getType().split(";"), activator, source, (CardTraitBase)ability);
        if (!this.canUntapSource) {
            typeList.remove(source);
        }
        typeList = CardLists.filter(typeList, CardPredicates.Presets.TAPPED, c -> c.getCounters(CounterEnumType.STUN) == 0 || c.canRemoveCounters(CounterType.get(CounterEnumType.STUN)));
        int amount = this.getAbilityAmount(ability);
        return typeList.size() != 0 && typeList.size() >= amount;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        targetCard.untap(true);
        return targetCard;
    }

    @Override
    protected boolean canPayListAtOnce() {
        return true;
    }

    @Override
    protected CardCollectionView doListPayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        CardCollection untapped = new CardCollection();
        for (Card c : targetCards) {
            if (!c.untap(true)) continue;
            untapped.add(c);
        }
        if (!untapped.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            HashMap<Player, CardCollection> map = Maps.newHashMap();
            map.put(payer, untapped);
            runParams.put(AbilityKey.Map, map);
            payer.getGame().getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
        }
        return targetCards;
    }

    @Override
    public String getHashForLKIList() {
        return "Untapped";
    }

    @Override
    public String getHashForCardList() {
        return "UntappedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

