/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.card.Card;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;

public class CostRevealChosen
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostRevealChosen(String type, String desc) {
        super("1", type, desc);
    }

    @Override
    public int paymentOrder() {
        return 20;
    }

    @Override
    public final String toString() {
        if (this.getType().equals("Player")) {
            return "Reveal the player you chose";
        }
        if (this.getType().equals("Type")) {
            return "Reveal the chosen " + this.getDescriptiveType().toLowerCase();
        }
        return "Update CostRevealChosen.java";
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player activator, boolean effect) {
        Card source = ability.getHostCard();
        if (this.getType().equals("Player")) {
            return source.hasChosenPlayer() && source.getTurnInController().equals(activator);
        }
        if (this.getType().equals("Type")) {
            return source.hasChosenType() && source.getTurnInController().equals(activator);
        }
        return false;
    }

    @Override
    public boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        Card host = ability.getHostCard();
        String o = "";
        if (this.getType().equals("Player")) {
            o = host.getChosenPlayer().toString();
            host.revealChosenPlayer();
        } else if (this.getType().equals("Type")) {
            o = host.getChosenType();
            host.revealChosenType();
        }
        String message = Localizer.getInstance().getMessage("lblPlayerReveals", ai, o);
        ai.getGame().getAction().notifyOfValue(ability, host, message, ai);
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

