/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import java.util.List;

public class CostRemoveCounter
extends CostPart {
    private static final long serialVersionUID = 1L;
    public final CounterType counter;
    public final List<ZoneType> zone;
    public final Boolean oneOrMore;

    public CostRemoveCounter(String amount, CounterType counter, String type, String description, List<ZoneType> zone, boolean oneOrMore) {
        super(amount, type, description);
        this.counter = counter;
        this.zone = zone;
        this.oneOrMore = oneOrMore;
    }

    @Override
    public int paymentOrder() {
        return 8;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        CounterType cntrs = this.counter;
        Card source = ability.getHostCard();
        String type = this.getType();
        if (this.payCostFromSource()) {
            return source.getCounters(cntrs);
        }
        List<Card> typeList = type.equals("OriginalHost") ? Lists.newArrayList(ability.getOriginalHost()) : CardLists.getValidCards((Iterable<Card>)payer.getCardsIn(this.zone), type.split(";"), payer, source, (CardTraitBase)ability);
        int maxcount = 0;
        for (Card c : typeList) {
            maxcount = Math.max(maxcount, c.getCounters(cntrs));
        }
        return maxcount;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.counter.is(CounterEnumType.LOYALTY) && this.payCostFromSource()) {
            sb.append("-").append(this.getAmount());
        } else {
            sb.append("Remove ");
            if (this.getAmount().equals("X")) {
                if (this.oneOrMore.booleanValue()) {
                    sb.append("one or more ");
                } else {
                    sb.append("any number of ");
                }
                sb.append(this.counter.getName().toLowerCase()).append(" counters");
            } else if (this.getAmount().equals("All")) {
                sb.append("all ").append(this.counter.getName().toLowerCase()).append(" counters");
            } else {
                sb.append(Lang.nounWithNumeralExceptOne(this.getAmount(), this.counter.getName().toLowerCase() + " counter"));
            }
            sb.append(" from ");
            if (this.payCostFromSource()) {
                sb.append(this.getType());
            } else {
                String desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
                sb.append(desc);
            }
        }
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        CounterType cntrs = this.counter;
        Card source = ability.getHostCard();
        String type = this.getType();
        int amount = this.getAmount().equals("All") ? source.getCounters(cntrs) : this.getAbilityAmount(ability);
        if (this.payCostFromSource()) {
            return !source.isPhasedOut() && source.getCounters(cntrs) - amount >= 0;
        }
        List<Card> typeList = type.equals("OriginalHost") ? Lists.newArrayList(ability.getOriginalHost()) : CardLists.getValidCards((Iterable<Card>)payer.getCardsIn(this.zone), type.split(";"), payer, source, (CardTraitBase)ability);
        for (Card c : typeList) {
            if (c.getCounters(cntrs) - amount < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        int removed = 0;
        int toRemove = decision.c;
        for (Card c : decision.cards) {
            removed += toRemove;
            c.subtractCounter(this.counter, toRemove, ai);
            c.getGame().updateLastStateForCard(c);
        }
        ability.setSVar("CostCountersRemoved", Integer.toString(removed));
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

