/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class CostPutCardToLib
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    public final ZoneType from;
    public final boolean sameZone;
    private String libPosition = "0";

    public final ZoneType getFrom() {
        return this.from;
    }

    public final String getLibPos() {
        return this.libPosition;
    }

    public final boolean isSameZone() {
        return this.sameZone;
    }

    public CostPutCardToLib(String amount, String libpos, String type, String description, ZoneType from) {
        this(amount, libpos, type, description, from, false);
    }

    public CostPutCardToLib(String amount, String libpos, String type, String description, ZoneType from0, boolean sameZone0) {
        super(amount, type, description);
        this.from = from0 == null ? ZoneType.Hand : from0;
        this.libPosition = libpos;
        this.sameZone = sameZone0;
    }

    @Override
    public int paymentOrder() {
        return 10;
    }

    @Override
    public final String toString() {
        String desc;
        StringBuilder sb = new StringBuilder();
        Integer i = this.convertAmount();
        sb.append("Put ");
        String string = desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
        if (this.payCostFromSource()) {
            sb.append(this.getType());
        } else {
            sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), desc));
        }
        if (this.sameZone) {
            sb.append(" from the same ").append((Object)this.from);
        } else if (!this.payCostFromSource()) {
            sb.append(" from your ").append((Object)this.from);
        }
        sb.append(" on ");
        if (this.libPosition.equals("0")) {
            sb.append("top of");
        } else {
            sb.append("the bottom of");
        }
        if (this.sameZone) {
            sb.append(" their owner's library");
        } else if (this.payCostFromSource()) {
            sb.append(" its owner's library");
        } else {
            sb.append(" your library");
        }
        return sb.toString();
    }

    @Override
    public String getHashForLKIList() {
        return "CardPutToLib";
    }

    @Override
    public String getHashForCardList() {
        return "CardPutToLibCards";
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        Game game = source.getGame();
        int i = this.getAbilityAmount(ability);
        CardCollectionView typeList = this.sameZone ? game.getCardsIn(this.getFrom()) : payer.getCardsIn(this.getFrom());
        if (this.payCostFromSource()) {
            return typeList.contains(source);
        }
        if ((typeList = CardLists.getValidCards((Iterable<Card>)typeList, this.getType().split(";"), payer, source, (CardTraitBase)ability)).size() < i) {
            return false;
        }
        if (this.sameZone) {
            boolean foundPayable = false;
            PlayerCollection players = game.getPlayers();
            for (Player p : players) {
                if (CardLists.count(typeList, CardPredicates.isController(p)) < i) continue;
                foundPayable = true;
                break;
            }
            return foundPayable;
        }
        return true;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(moveParams, this.table);
        return targetCard.getGame().getAction().moveToLibrary(targetCard, Integer.parseInt(this.getLibPos()), null, moveParams);
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

