/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Maps;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.cost.CostPartWithList;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import java.util.HashMap;

public abstract class CostPartWithTrigger
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    protected Trigger payTrig;

    public CostPartWithTrigger(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    protected final void handleBeforePayment(Player ai, SpellAbility ability, CardCollectionView targetCards) {
        if (this.payingTrigSA != null) {
            Card source = this.payingTrigSA.getHostCard();
            HashMap<String, String> mapParams = Maps.newHashMap();
            mapParams.put("TriggerDescription", this.payingTrigSA.getParam("SpellDescription"));
            mapParams.put("Mode", TriggerType.Immediate.name());
            SpellAbility sa = this.payingTrigSA.copy(source, ability.getActivatingPlayer(), false);
            sa.changeText();
            this.payTrig = TriggerHandler.parseTrigger(mapParams, source, sa.isIntrinsic(), null);
            this.payTrig.setSpawningAbility(ability);
            this.payTrig.setOverridingAbility(sa);
            ai.getGame().getTriggerHandler().registerDelayedTrigger(this.payTrig);
        }
    }
}

