/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardZoneTable;
import forge.game.cost.CostPart;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public abstract class CostPartWithList
extends CostPart {
    private static final long serialVersionUID = 1L;
    private final CardCollection lkiList = new CardCollection();
    protected final CardCollection cardList = new CardCollection();
    private boolean intrinsic = true;
    protected final CardZoneTable table = new CardZoneTable();

    public final CardCollectionView getLKIList() {
        return this.lkiList;
    }

    public final CardCollectionView getCardList() {
        return this.cardList;
    }

    public final void setIntrinsic(boolean b) {
        this.intrinsic = b;
    }

    public void resetLists() {
        this.lkiList.clear();
        this.cardList.clear();
        this.table.clear();
    }

    public final void reportPaidCardsTo(SpellAbility sa) {
        if (sa == null) {
            return;
        }
        String lkiPaymentMethod = this.getHashForLKIList();
        for (Card card : this.lkiList) {
            sa.addCostToHashList(card, lkiPaymentMethod, this.intrinsic);
        }
        String cardPaymentMethod = this.getHashForCardList();
        for (Card card : this.cardList) {
            sa.addCostToHashList(card, cardPaymentMethod, this.intrinsic);
        }
    }

    public CostPartWithList() {
    }

    public CostPartWithList(String amount, String type, String description) {
        super(amount, type, description);
    }

    public final boolean executePayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        this.lkiList.add(CardCopyService.getLKICopy(targetCard));
        Card newCard = this.doPayment(payer, ability, targetCard, effect);
        targetCard.getGame().updateLastStateForCard(targetCard);
        if (newCard != null) {
            this.cardList.add(newCard);
        }
        return true;
    }

    protected boolean executePayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        this.table.setLastStateBattlefield(payer.getGame().copyLastStateBattlefield());
        this.table.setLastStateGraveyard(payer.getGame().copyLastStateGraveyard());
        this.handleBeforePayment(payer, ability, targetCards);
        if (this.canPayListAtOnce()) {
            for (Card c : targetCards) {
                this.lkiList.add(CardCopyService.getLKICopy(c));
            }
            this.cardList.addAll(this.doListPayment(payer, ability, targetCards, effect));
        } else {
            for (Card c : targetCards) {
                this.executePayment(payer, ability, c, effect);
            }
        }
        this.handleChangeZoneTrigger(payer, ability, targetCards);
        return true;
    }

    protected abstract Card doPayment(Player var1, SpellAbility var2, Card var3, boolean var4);

    protected boolean canPayListAtOnce() {
        return false;
    }

    protected CardCollectionView doListPayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        return CardCollection.EMPTY;
    }

    public abstract String getHashForLKIList();

    public abstract String getHashForCardList();

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision decision, SpellAbility ability, boolean effect) {
        this.executePayment(payer, ability, decision.cards, effect);
        this.reportPaidCardsTo(ability);
        return true;
    }

    protected void handleBeforePayment(Player payer, SpellAbility ability, CardCollectionView targetCards) {
    }

    protected void handleChangeZoneTrigger(Player payer, SpellAbility ability, CardCollectionView targetCards) {
        if (this.table.isEmpty()) {
            return;
        }
        this.table.triggerChangesZoneAll(payer.getGame(), ability);
    }
}

