/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.card.mana.ManaCost;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CostPartMana
extends CostPart {
    private static final long serialVersionUID = 1L;
    private final ManaCost cost;
    private int xMin = 0;
    private boolean isExiledCreatureCost = false;
    private boolean isEnchantedCreatureCost = false;
    private boolean isCostPayAnyNumberOfTimes = false;

    @Override
    public int paymentOrder() {
        return this.shouldPayLast() ? 200 : 0;
    }

    public boolean shouldPayLast() {
        return this.isExiledCreatureCost;
    }

    public CostPartMana(ManaCost cost, String restriction) {
        this.cost = cost;
        if (restriction != null && restriction.startsWith("XMin")) {
            this.xMin = Integer.parseInt(restriction.substring(4));
        }
        this.isExiledCreatureCost = "Exiled".equalsIgnoreCase(restriction);
        this.isEnchantedCreatureCost = "EnchantedCost".equalsIgnoreCase(restriction);
        this.isCostPayAnyNumberOfTimes = "NumTimes".equalsIgnoreCase(restriction);
    }

    public CostPartMana(ManaCost cost, boolean exiledCreatureCost, boolean enchantedCreatureCost, int xMin) {
        this.cost = cost;
        this.xMin = xMin;
        this.isExiledCreatureCost = exiledCreatureCost;
        this.isEnchantedCreatureCost = enchantedCreatureCost;
    }

    public final ManaCost getMana() {
        return this.cost;
    }

    public final int getAmountOfX() {
        return this.cost.countX();
    }

    public int getXMin() {
        return this.xMin;
    }

    public boolean isExiledCreatureCost() {
        return this.isExiledCreatureCost;
    }

    public boolean isEnchantedCreatureCost() {
        return this.isEnchantedCreatureCost;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public final String toString() {
        return this.cost.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public ManaCost getManaCostFor(SpellAbility sa) {
        if (this.isExiledCreatureCost() && sa.getPaidList("Exiled", true) != null && !sa.getPaidList("Exiled", true).isEmpty()) {
            ManaCost mod = ((Card)sa.getPaidList("Exiled", true).get(false)).getManaCost();
            if (mod.isNoCost()) {
                return mod;
            }
            ManaCostBeingPaid manaCostNew = new ManaCostBeingPaid(this.getMana());
            manaCostNew.addManaCost(mod);
            return manaCostNew.toManaCost();
        }
        if (this.isEnchantedCreatureCost() && sa.getHostCard().isEnchantingCard()) {
            ManaCost mod = sa.getHostCard().getEnchantingCard().getManaCost();
            if (mod.isNoCost()) {
                return mod;
            }
            ManaCostBeingPaid manaCostNew = new ManaCostBeingPaid(this.getMana());
            manaCostNew.addManaCost(mod);
            return manaCostNew.toManaCost();
        }
        if (this.isCostPayAnyNumberOfTimes) {
            int timesToPay = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getSVar("NumTimes"), sa);
            if (timesToPay == 0) {
                return ManaCost.ZERO;
            }
            ManaCostBeingPaid totalMana = new ManaCostBeingPaid(this.getMana());
            for (int i = 1; i < timesToPay; ++i) {
                totalMana.addManaCost(this.getMana());
            }
            return totalMana.toManaCost();
        }
        return this.getMana();
    }

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision pd, SpellAbility sa, boolean effect) {
        sa.clearManaPaid();
        ManaConversionMatrix old = new ManaConversionMatrix();
        old.restoreColorReplacements();
        old.applyCardMatrix(payer.getManaPool());
        boolean result = payer.getController().payManaCost(this, sa, null, pd.matrix, effect);
        payer.getManaPool().restoreColorReplacements();
        payer.getManaPool().applyCardMatrix(old);
        return result;
    }
}

