/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import java.util.List;

public class CostGainLife
extends CostPart {
    private static final long serialVersionUID = 1L;
    private final int cntPlayers;

    public CostGainLife(String amount, String playerSelector, int qty) {
        super(amount, playerSelector, null);
        this.cntPlayers = qty;
    }

    public int getCntPlayers() {
        return this.cntPlayers;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Have an opponent gain ").append(this.getAmount()).append(" life");
        return sb.toString();
    }

    public List<Player> getPotentialTargets(Player payer, SpellAbility ability) {
        ArrayList<Player> res = Lists.newArrayList();
        for (Player p : payer.getGame().getPlayers()) {
            if (!p.isValid(this.getType(), payer, ability.getHostCard(), (CardTraitBase)ability)) continue;
            res.add(p);
        }
        return res;
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        int cntAbleToGainLife = 0;
        List<Player> possibleTargets = this.getPotentialTargets(payer, ability);
        for (Player opp : possibleTargets) {
            if (!opp.canGainLife()) continue;
            ++cntAbleToGainLife;
        }
        return cntAbleToGainLife >= this.cntPlayers || this.cntPlayers == Integer.MAX_VALUE && cntAbleToGainLife == possibleTargets.size();
    }

    @Override
    public final boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        int c = this.getAbilityAmount(ability);
        int playersLeft = this.cntPlayers;
        for (Player opp : decision.players) {
            if (playersLeft == 0) break;
            if (!opp.canGainLife()) {
                return false;
            }
            --playersLeft;
            opp.gainLife(c, ability.getHostCard(), ability);
        }
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

