/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class CostExiledMoveToGrave
extends CostPartWithList {
    private static final long serialVersionUID = 1L;

    public CostExiledMoveToGrave(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public int paymentOrder() {
        return 15;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollectionView typeList = payer.getGame().getCardsIn(ZoneType.Exile);
        typeList = CardLists.getValidCards((Iterable<Card>)typeList, this.getType().split(";"), payer, source, (CardTraitBase)ability);
        return typeList.size();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        Integer i = this.convertAmount();
        sb.append("Put ");
        String desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
        sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), desc));
        sb.append(" from exile into that player's graveyard");
        return sb.toString();
    }

    @Override
    public String getHashForLKIList() {
        return "MovedToGrave";
    }

    @Override
    public String getHashForCardList() {
        return "MovedToGraveCards";
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        int i = this.getAbilityAmount(ability);
        return this.getMaxAmountX(ability, payer, effect) >= i;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(moveParams, this.table);
        return targetCard.getGame().getAction().moveToGraveyard(targetCard, null, moveParams);
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

