/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class CostExileFromStack
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostExileFromStack(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public int paymentOrder() {
        return 15;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        Integer i = this.convertAmount();
        sb.append("Exile ");
        String desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
        sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), desc));
        sb.append("from stack");
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        String type = this.getType();
        if (type.equals("All")) {
            return true;
        }
        CardCollectionView list = source.getGame().getCardsIn(ZoneType.Stack);
        list = CardLists.getValidCards((Iterable<Card>)list, type.split(";"), payer, source, (CardTraitBase)ability);
        int amount = this.getAbilityAmount(ability);
        return list.size() >= amount;
    }

    @Override
    public final boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        Game game = ai.getGame();
        CardCollection list = new CardCollection();
        for (SpellAbility sa : decision.sp) {
            ability.addCostToHashList(CardCopyService.getLKICopy(sa.getHostCard()), "Exiled", true);
            SpellAbilityStackInstance si = game.getStack().getInstanceMatchingSpellAbilityID(sa);
            if (si != null) {
                game.getStack().remove(si);
            }
            list.add(sa.getHostCard());
        }
        if (list.isEmpty()) {
            return true;
        }
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, ability);
        CardCollection moved = game.getAction().exile(list, ability, moveParams);
        SpellAbilityEffect.handleExiledWith(moved, ability);
        zoneMovements.triggerChangesZoneAll(game, ability);
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

