/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Lists;
import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.EnumMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CostExile
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    public final List<ZoneType> from = Lists.newArrayList();
    public final int zoneRestriction;
    public static final String HashLKIListKey = "Exiled";
    public static final String HashCardListKey = "ExiledCards";

    public final List<ZoneType> getFrom() {
        return this.from;
    }

    public CostExile(String amount, String type, String description, ZoneType from) {
        this(amount, type, description, from, Lists.newArrayList(), 1);
    }

    public CostExile(String amount, String type, String description, ZoneType from, int zoneMode) {
        this(amount, type, description, from, Lists.newArrayList(), zoneMode);
    }

    public CostExile(String amount, String type, String description, List<ZoneType> froms) {
        this(amount, type, description, null, froms, 1);
    }

    public CostExile(String amount, String type, String description, ZoneType from, List<ZoneType> froms, int zoneMode) {
        super(amount, type, description);
        if (from != null) {
            froms.add(from);
        }
        if (froms.isEmpty()) {
            this.from.add(ZoneType.Battlefield);
        } else {
            this.from.addAll(froms);
        }
        this.zoneRestriction = zoneMode;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        Game game = source.getGame();
        CardCollectionView typeList = this.zoneRestriction != 1 ? game.getCardsIn(this.from) : payer.getCardsIn(this.from);
        typeList = CardLists.getValidCards((Iterable<Card>)typeList, this.getType().split(";"), payer, source, (CardTraitBase)ability);
        return typeList.size();
    }

    @Override
    public int paymentOrder() {
        if (this.from.contains((Object)ZoneType.Library)) {
            return 20;
        }
        return 15;
    }

    @Override
    public final String toString() {
        return this.toString(0);
    }

    public final String toString(int chosenX) {
        Integer i = this.convertAmount();
        String desc = this.getDescriptiveType();
        if (this.from.size() == 1) {
            String origin = this.from.get(0).name().toLowerCase();
            if (this.payCostFromSource()) {
                if (!origin.equals("battlefield")) {
                    return String.format("Exile %s from your %s", this.getType(), origin);
                }
                return String.format("Exile %s", this.getType());
            }
            if (this.getType().equals("All")) {
                return String.format("Exile all cards from your %s", origin);
            }
            if (origin.equals("battlefield")) {
                String amt;
                if (i == null && this.getAmount().contains("+")) {
                    int needed = Integer.parseInt(this.getAmount().split("\\+")[0]);
                    amt = Lang.getNumeral(needed) + " or more " + desc;
                } else {
                    amt = Cost.convertAmountTypeToWords(i, this.getAmount(), desc);
                }
                return "Exile " + amt + (amt.contains("you control") ? "" : " you control");
            }
            if (!desc.equals("Card") && !desc.contains("card")) {
                StringBuilder sb = new StringBuilder();
                sb.append("Exile %s from ");
                if (this.zoneRestriction == 0) {
                    sb.append("the same");
                } else if (this.zoneRestriction == -1) {
                    sb.append("a");
                } else {
                    sb.append("your");
                }
                sb.append(" %s");
                return String.format(sb.toString(), Lang.nounWithNumeralExceptOne(this.getAmount(), desc + " card"), origin);
            }
            if (this.zoneRestriction == 0) {
                return String.format("Exile %s from the same %s", Cost.convertAmountTypeToWords(i, this.getAmount(), desc), origin);
            }
            if (this.getAmount().equals("X")) {
                String x = chosenX > 0 ? Lang.getNumeral(chosenX) : "any number of";
                return String.format("Exile %s %s from your %s", x, desc, origin);
            }
            return String.format("Exile %s from your %s", Cost.convertAmountTypeToWords(i, this.getAmount(), desc), origin);
        }
        return this.exileMultiZoneCostString(false, chosenX);
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        CostExile firstExileCost;
        Card source = ability.getHostCard();
        Game game = source.getGame();
        String type = this.getType();
        if (type.equals("All")) {
            return true;
        }
        if (type.contains("FromTopGrave")) {
            type = TextUtil.fastReplace(type, "FromTopGrave", "");
        }
        CardCollection list = CardLists.filter((Iterable<Card>)(this.zoneRestriction != 1 ? game.getCardsIn(this.from) : payer.getCardsIn(this.from)), CardPredicates.canExiledBy(ability, effect));
        if (this.payCostFromSource()) {
            return list.contains(source);
        }
        boolean totalCMC = false;
        String totalM = "";
        if (type.contains("+withTotalCMCEQ")) {
            totalCMC = true;
            totalM = type.split("withTotalCMCEQ")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalCMCEQ", totalM), "");
        }
        boolean totalCMCgreater = false;
        if (type.contains("+withTotalCMCGE")) {
            totalCMCgreater = true;
            totalM = type.split("withTotalCMCGE")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalCMCGE", totalM), "");
        }
        boolean sharedType = false;
        if (type.contains("+withSharedCardType")) {
            sharedType = true;
            type = TextUtil.fastReplace(type, "+withSharedCardType", "");
        }
        int nTypes = -1;
        if (type.contains("+withTypesGE")) {
            String num = type.split("withTypesGE")[1];
            type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTypesGE", num), "");
            nTypes = Integer.parseInt(num);
        }
        if (!type.contains("X") || ability.getXManaCostPaid() != null) {
            list = CardLists.getValidCards((Iterable<Card>)list, type.split(";"), payer, source, (CardTraitBase)ability);
        }
        int amount = this.getAbilityAmount(ability);
        if (nTypes > -1 && CardFactoryUtil.getCardTypesFromList(list) < nTypes) {
            return false;
        }
        if (sharedType) {
            if (list.size() < amount) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                Card card1 = (Card)list.get(i);
                for (Card compare : list) {
                    if (compare.equals(card1) || !compare.sharesCardTypeWith(card1)) continue;
                    return true;
                }
            }
            return false;
        }
        if (totalCMC || totalCMCgreater) {
            if (totalM.equals("X") && ability.getXManaCostPaid() == null) {
                return true;
            }
            int i = AbilityUtils.calculateAmount(source, totalM, ability);
            return totalCMCgreater ? CardLists.getTotalCMC(list) >= i : CardLists.cmcCanSumTo(i, list);
        }
        if (ability.isCraft() && (firstExileCost = ability.getPayCosts().getCostPartByType(CostExile.class)) != null && firstExileCost.payCostFromSource()) {
            list.remove(ability.getHostCard());
        }
        if (this.from.size() == 1 && this.from.get(0).equals((Object)ZoneType.Hand) && source.isInZone(ZoneType.Hand) && list.contains(source)) {
            ++amount;
        }
        if (list.size() < amount) {
            return false;
        }
        if (this.zoneRestriction == 0) {
            boolean foundPayable = false;
            PlayerCollection players = game.getPlayers();
            for (Player p : players) {
                if (CardLists.count(list, CardPredicates.isController(p)) < amount) continue;
                foundPayable = true;
                break;
            }
            return foundPayable;
        }
        return true;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(moveParams, this.table);
        Card newCard = targetCard.getGame().getAction().exile(targetCard, null, moveParams);
        SpellAbilityEffect.handleExiledWith(newCard, ability);
        return newCard;
    }

    public String exileMultiZoneCostString(boolean forKW, int xMin) {
        String plurNoun;
        StringBuilder sb = new StringBuilder();
        sb.append("Exile ");
        String amount = this.getAmount();
        int amt = StringUtils.isNumeric(amount) ? Integer.parseInt(amount) : 0;
        String partType = this.getType();
        if (partType.contains(".Other")) {
            partType = partType.replace(".Other", "");
        }
        String singNoun = this.getTypeDescription() != null ? this.getTypeDescription() : (CardType.CoreType.isValidEnum(partType) || partType.equals("Permanent") ? partType.toLowerCase() : partType);
        String string = plurNoun = !singNoun.contains(" ") ? Lang.getPlural(singNoun) : singNoun;
        if (!forKW && amt == 0 && xMin > 0) {
            amt = xMin;
        }
        boolean perm = singNoun.equals("permanent");
        if (amt == 1) {
            String aNoun = Lang.nounWithNumeralExceptOne(1, singNoun);
            sb.append(partType.equals("Artifact") || perm ? "another " + singNoun : aNoun);
            sb.append(" you control or ").append(aNoun).append(" card from ");
        } else if (amt > 1) {
            sb.append("the ").append(Lang.getNumeral(amt)).append(" from among ");
            sb.append(perm ? "other " : "").append(plurNoun).append(" you control and/or ").append(singNoun);
            sb.append(" cards in ");
        } else {
            sb.append(xMin > 1 ? "the " : "").append(Lang.getNumeral(xMin)).append(forKW ? " or more " : " ");
            if (xMin == 1) {
                sb.append(perm ? "other " : "").append(plurNoun).append(" you control and/or ");
                sb.append(!perm ? singNoun : "").append(" cards from ");
            } else if (this.getFrom().size() > 1) {
                sb.append("from among ").append(perm ? "other " : "").append(plurNoun);
                sb.append(" you control and/or cards from ");
            } else {
                sb.append("from ");
            }
        }
        sb.append("your graveyard");
        return sb.toString();
    }

    @Override
    public String getHashForLKIList() {
        return HashLKIListKey;
    }

    @Override
    public String getHashForCardList() {
        return HashCardListKey;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

