/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.GameEntityCounterTable;
import forge.game.card.Card;
import forge.game.card.CardDamageMap;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CostDamage
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostDamage(String amount) {
        this.setAmount(amount);
    }

    @Override
    public int paymentOrder() {
        return 8;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Deal ").append(this.getAmount()).append(" damage to you");
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return true;
    }

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision decision, SpellAbility sa, boolean effect) {
        Card source = sa.getHostCard();
        CardDamageMap damageMap = new CardDamageMap();
        CardDamageMap preventMap = new CardDamageMap();
        GameEntityCounterTable table = new GameEntityCounterTable();
        damageMap.put(source, payer, decision.c);
        source.getGame().getAction().dealDamage(false, damageMap, preventMap, table, sa);
        return decision.c > 0;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

