/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CostChooseColor
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostChooseColor(String amount) {
        this.setAmount(amount);
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return true;
    }

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision pd, SpellAbility sa, boolean effect) {
        sa.getHostCard().setChosenColors(pd.colors);
        return true;
    }

    @Override
    public int paymentOrder() {
        return 8;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        Integer i = this.convertAmount();
        sb.append("Choose ");
        sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), "color"));
        return sb.toString();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public final void refund(Card source) {
        source.setChosenColors(null);
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

