/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.card.mana.ManaAtom;
import forge.game.card.Card;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.mana.Mana;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class CostAddMana
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostAddMana(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public int paymentOrder() {
        return 5;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        Integer i = this.convertAmount();
        sb.append("Add ").append(StringUtils.repeat("{" + this.getType() + "}", (int)i));
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return true;
    }

    @Override
    public boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility sa, boolean effect) {
        Card source = sa.getHostCard();
        ArrayList<Mana> manaProduced = new ArrayList<Mana>();
        String type = this.getType();
        for (int n = 0; n < decision.c; ++n) {
            if (StringUtils.isNumeric(type)) {
                for (int i = Integer.parseInt(type); i > 0; --i) {
                    manaProduced.add(new Mana(32, source, null));
                }
                continue;
            }
            byte attemptedMana = ManaAtom.fromName(type);
            manaProduced.add(new Mana(attemptedMana, source, null));
        }
        ai.getManaPool().add(manaProduced);
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

