/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.primitives.Ints;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.staticability.StaticAbilityAttackRestrict;
import forge.util.collect.FCollectionView;
import forge.util.maps.LinkedHashMapToAmount;
import forge.util.maps.MapToAmount;
import forge.util.maps.MapToAmountUtil;
import java.util.Map;

public class GlobalAttackRestrictions {
    private final int max;
    private final MapToAmount<GameEntity> defenderMax;

    private GlobalAttackRestrictions(int max, MapToAmount<GameEntity> defenderMax) {
        this.max = max;
        this.defenderMax = defenderMax;
    }

    public int getMax() {
        return this.max;
    }

    public MapToAmount<GameEntity> getDefenderMax() {
        return this.defenderMax;
    }

    public boolean isLegal(Map<Card, GameEntity> attackers) {
        return !this.getViolations(attackers, true).isViolated();
    }

    public GlobalAttackRestrictionViolations getViolations(Map<Card, GameEntity> attackers) {
        return this.getViolations(attackers, false);
    }

    private GlobalAttackRestrictionViolations getViolations(Map<Card, GameEntity> attackers, boolean returnQuickly) {
        int nTooMany;
        int n = nTooMany = this.max < 0 ? 0 : attackers.size() - this.max;
        if (returnQuickly && nTooMany > 0) {
            return new GlobalAttackRestrictionViolations(nTooMany, MapToAmountUtil.emptyMap());
        }
        LinkedHashMapToAmount<GameEntity> defenderTooMany = new LinkedHashMapToAmount<GameEntity>(this.defenderMax.size());
        block0: for (GameEntity defender : attackers.values()) {
            Integer max = (Integer)this.defenderMax.get(defender);
            if (max == null) continue;
            if (returnQuickly && max == 0) {
                defenderTooMany.put(defender, 1);
                break;
            }
            int count = 0;
            for (Map.Entry<Card, GameEntity> attDef : attackers.entrySet()) {
                if (attDef.getValue() != defender || !returnQuickly || ++count <= max) continue;
                defenderTooMany.put(defender, count - max);
                break block0;
            }
            int nDefTooMany = count - max;
            if (nDefTooMany <= 0) continue;
            defenderTooMany.put(defender, nDefTooMany);
        }
        return new GlobalAttackRestrictionViolations(nTooMany, defenderTooMany);
    }

    public static GlobalAttackRestrictions getGlobalRestrictions(Player attackingPlayer, FCollectionView<GameEntity> possibleDefenders) {
        LinkedHashMapToAmount<GameEntity> defenderMax = new LinkedHashMapToAmount<GameEntity>(possibleDefenders.size());
        Game game = attackingPlayer.getGame();
        int max = StaticAbilityAttackRestrict.globalAttackRestrict(game);
        for (GameEntity defender : possibleDefenders) {
            int defMax = StaticAbilityAttackRestrict.attackRestrictNum(defender);
            if (defMax == -1) continue;
            defenderMax.add(defender, defMax);
        }
        if (defenderMax.size() == possibleDefenders.size()) {
            max = Ints.min(max, defenderMax.countAll());
        }
        return new GlobalAttackRestrictions(max, defenderMax);
    }

    final class GlobalAttackRestrictionViolations {
        private final boolean isViolated;
        private final int globalTooMany;
        private final MapToAmount<GameEntity> defenderTooMany;

        public GlobalAttackRestrictionViolations(int globalTooMany, MapToAmount<GameEntity> defenderTooMany) {
            this.isViolated = globalTooMany > 0 || !defenderTooMany.isEmpty();
            this.globalTooMany = globalTooMany;
            this.defenderTooMany = defenderTooMany;
        }

        public boolean isViolated() {
            return this.isViolated;
        }

        public int getGlobalTooMany() {
            return this.globalTooMany;
        }

        public MapToAmount<GameEntity> getDefenderTooMany() {
            return this.defenderTooMany;
        }
    }
}

