/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.collect.Iterables;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.combat.AttackRestrictionType;
import forge.game.combat.CombatUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class AttackRestriction {
    private final Card attacker;
    private final Set<AttackRestrictionType> restrictions = EnumSet.noneOf(AttackRestrictionType.class);
    private boolean cantAttack;
    private final FCollectionView<GameEntity> cantAttackDefender;

    public AttackRestriction(Card attacker, FCollectionView<GameEntity> possibleDefenders) {
        this.attacker = attacker;
        this.setRestrictions();
        FCollection<GameEntity> cantAttackDefender = new FCollection<GameEntity>();
        for (GameEntity defender : possibleDefenders) {
            if (CombatUtil.canAttack(attacker, defender)) continue;
            cantAttackDefender.add(defender);
        }
        this.cantAttackDefender = cantAttackDefender;
        if (this.restrictions.contains((Object)AttackRestrictionType.ONLY_ALONE) && (this.restrictions.contains((Object)AttackRestrictionType.NEED_GREATER_POWER) || this.restrictions.contains((Object)AttackRestrictionType.NEED_BLACK_OR_GREEN) || this.restrictions.contains((Object)AttackRestrictionType.NOT_ALONE) || this.restrictions.contains((Object)AttackRestrictionType.NEED_TWO_OTHERS)) || this.restrictions.contains((Object)AttackRestrictionType.NEVER) || cantAttackDefender.size() == possibleDefenders.size()) {
            this.cantAttack = true;
        }
    }

    public boolean canAttack(GameEntity defender) {
        return !this.cantAttack && !this.cantAttackDefender.contains(defender);
    }

    public Set<AttackRestrictionType> getViolation(Map<Card, GameEntity> attackers) {
        EnumSet<AttackRestrictionType> violations = EnumSet.noneOf(AttackRestrictionType.class);
        int nAttackers = attackers.size();
        if (this.restrictions.contains((Object)AttackRestrictionType.ONLY_ALONE) && nAttackers > 1) {
            violations.add(AttackRestrictionType.ONLY_ALONE);
        }
        if (this.restrictions.contains((Object)AttackRestrictionType.NEED_GREATER_POWER) && !Iterables.any(attackers.keySet(), AttackRestrictionType.NEED_GREATER_POWER.getPredicate(this.attacker))) {
            violations.add(AttackRestrictionType.NEED_GREATER_POWER);
        }
        if (this.restrictions.contains((Object)AttackRestrictionType.NEED_BLACK_OR_GREEN) && !Iterables.any(attackers.keySet(), AttackRestrictionType.NEED_BLACK_OR_GREEN.getPredicate(this.attacker))) {
            violations.add(AttackRestrictionType.NEED_BLACK_OR_GREEN);
        }
        if (this.restrictions.contains((Object)AttackRestrictionType.NOT_ALONE) && nAttackers <= 1) {
            violations.add(AttackRestrictionType.NOT_ALONE);
        }
        if (this.restrictions.contains((Object)AttackRestrictionType.NEED_TWO_OTHERS) && nAttackers <= 2) {
            violations.add(AttackRestrictionType.NEED_TWO_OTHERS);
        }
        return violations;
    }

    public boolean canAttack(GameEntity defender, Map<Card, GameEntity> attackers) {
        if (!this.canAttack(defender)) {
            return false;
        }
        return this.getViolation(attackers).isEmpty();
    }

    public Set<AttackRestrictionType> getTypes() {
        return Collections.unmodifiableSet(this.restrictions);
    }

    private void setRestrictions() {
        if (this.attacker.hasKeyword("CARDNAME can only attack alone.")) {
            this.restrictions.add(AttackRestrictionType.ONLY_ALONE);
        }
        if (this.attacker.hasKeyword("CARDNAME can't attack unless a creature with greater power also attacks.")) {
            this.restrictions.add(AttackRestrictionType.NEED_GREATER_POWER);
        }
        if (this.attacker.hasKeyword("CARDNAME can't attack unless a black or green creature also attacks.")) {
            this.restrictions.add(AttackRestrictionType.NEED_BLACK_OR_GREEN);
        }
        if (this.attacker.hasKeyword("CARDNAME can't attack or block alone.") || this.attacker.hasKeyword("CARDNAME can't attack alone.")) {
            this.restrictions.add(AttackRestrictionType.NOT_ALONE);
        }
        if (this.attacker.hasKeyword("CARDNAME can't attack unless at least two other creatures attack.")) {
            this.restrictions.add(AttackRestrictionType.NEED_TWO_OTHERS);
        }
    }
}

