/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card.token;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ImageKeys;
import forge.StaticData;
import forge.card.CardType;
import forge.card.GamePieceType;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardFactory;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardUtil;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.item.PaperToken;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TokenInfo {
    final String name;
    final String imageName;
    final String manaCost;
    final String[] types;
    final String[] intrinsicKeywords;
    final int basePower;
    final int baseToughness;
    final String color;

    public TokenInfo(Card c) {
        this.name = c.getName();
        this.imageName = ImageKeys.getTokenImageName(c.getImageKey());
        this.manaCost = c.getManaCost().toString();
        this.color = MagicColor.toShortString(c.getCurrentState().getColor());
        this.types = TokenInfo.getCardTypes(c);
        ArrayList<String> list = Lists.newArrayList();
        for (KeywordInterface inst : c.getKeywords()) {
            list.add(inst.getOriginal());
        }
        this.intrinsicKeywords = list.toArray(new String[0]);
        this.basePower = c.getBasePower();
        this.baseToughness = c.getBaseToughness();
    }

    public TokenInfo(String str) {
        String[] tokenInfo = str.split(",");
        int power = 0;
        int toughness = 0;
        String manaCost = "0";
        String[] types = null;
        String[] keywords = null;
        String imageName = null;
        String color = "";
        for (String info : tokenInfo) {
            int index = info.indexOf(58);
            if (index == -1) continue;
            String remainder = info.substring(index + 1);
            if (info.startsWith("P:")) {
                power = Integer.parseInt(remainder);
                continue;
            }
            if (info.startsWith("T:")) {
                toughness = Integer.parseInt(remainder);
                continue;
            }
            if (info.startsWith("Cost:")) {
                manaCost = remainder;
                continue;
            }
            if (info.startsWith("Types:")) {
                types = remainder.split("-");
                continue;
            }
            if (info.startsWith("Keywords:")) {
                keywords = remainder.split("-");
                continue;
            }
            if (info.startsWith("Image:")) {
                imageName = remainder;
                continue;
            }
            if (!info.startsWith("Color:")) continue;
            color = remainder;
        }
        this.name = tokenInfo[0];
        this.imageName = imageName;
        this.manaCost = manaCost;
        this.types = types;
        this.intrinsicKeywords = keywords;
        this.basePower = power;
        this.baseToughness = toughness;
        this.color = color;
    }

    private static String[] getCardTypes(Card c) {
        ArrayList<String> relevantTypes = Lists.newArrayList();
        for (CardType.CoreType t2 : c.getType().getCoreTypes()) {
            relevantTypes.add(t2.name());
        }
        Iterables.addAll(relevantTypes, c.getType().getSubtypes());
        if (c.getType().isLegendary()) {
            relevantTypes.add("Legendary");
        }
        return relevantTypes.toArray(new String[0]);
    }

    private Card toCard(Game game) {
        return this.toCard(game, game.nextCardId());
    }

    private Card toCard(Game game, int id) {
        Card c = new Card(id, game);
        c.setName(this.name);
        c.setImageKey(ImageKeys.getTokenKey(this.imageName));
        c.setColor(this.color.isEmpty() ? this.manaCost : this.color);
        c.setGamePieceType(GamePieceType.TOKEN);
        for (String t2 : this.types) {
            c.addType(t2);
        }
        c.setBasePower(this.basePower);
        c.setBaseToughness(this.baseToughness);
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(',');
        sb.append("P:").append(this.basePower).append(',');
        sb.append("T:").append(this.baseToughness).append(',');
        sb.append("Cost:").append(this.manaCost).append(',');
        sb.append("Color:").append(this.color).append(",");
        sb.append("Types:").append(Joiner.on('-').join(this.types)).append(',');
        sb.append("Keywords:").append(Joiner.on('-').join(this.intrinsicKeywords)).append(',');
        sb.append("Image:").append(this.imageName);
        return sb.toString();
    }

    public Card makeOneToken(Player controller) {
        return this.makeOneToken(controller, controller.getGame().nextCardId());
    }

    public Card makeOneToken(Player controller, int id) {
        Game game = controller.getGame();
        Card c = this.toCard(game, id);
        c.setOwner(controller);
        c.setGamePieceType(GamePieceType.TOKEN);
        CardFactoryUtil.setupKeywordedAbilities(c);
        for (String kw : this.intrinsicKeywords) {
            c.addIntrinsicKeyword(kw);
        }
        return c;
    }

    protected static void protoTypeApplyTextChange(Card result, SpellAbility sa) {
        Map<String, String> colorMap = sa.getChangedTextColors();
        Map<String, String> typeMap = sa.getChangedTextTypes();
        if (!colorMap.isEmpty() && !result.isColorless()) {
            byte color = result.getColor().getColor();
            for (Map.Entry<String, String> e : colorMap.entrySet()) {
                byte v = MagicColor.fromName(e.getValue());
                if ("Any".equals(e.getKey())) {
                    for (byte c : MagicColor.WUBRG) {
                        if ((color & c) == 0) continue;
                        color = (byte)(color & ~c);
                        color = (byte)(color | v);
                    }
                    continue;
                }
                byte c = MagicColor.fromName(e.getKey());
                if ((color & c) == 0) continue;
                color = (byte)(color & ~c);
                color = (byte)(color | v);
            }
            result.setColor(color);
        }
        if (!typeMap.isEmpty()) {
            CardType type = new CardType(result.getType());
            boolean nameGenerated = result.getName().endsWith(" Token");
            boolean typeChanged = false;
            if (!Iterables.isEmpty(type.getSubtypes())) {
                for (Map.Entry<String, String> e : typeMap.entrySet()) {
                    if (!type.hasSubtype(e.getKey())) continue;
                    type.remove(e.getKey());
                    type.add(e.getValue());
                    typeChanged = true;
                }
            }
            if (typeChanged) {
                result.setType(type);
                if (nameGenerated) {
                    result.setName(StringUtils.join(type.getSubtypes(), " ") + " Token");
                }
            }
        }
        ArrayList<KeywordInterface> toRemove = Lists.newArrayList();
        ArrayList<String> toAdd = Lists.newArrayList();
        for (KeywordInterface k : result.getCurrentState().getIntrinsicKeywords()) {
            String o = k.getOriginal();
            if (!CardUtil.isKeywordModifiable(o)) continue;
            String r = o;
            for (Map.Entry<String, String> e : typeMap.entrySet()) {
                String key = e.getKey();
                String pkey = CardType.getPluralType(key);
                String value = e.getValue();
                String pvalue = CardType.getPluralType(e.getValue());
                r = r.replaceAll(pkey, pvalue);
                r = r.replaceAll(key, value);
            }
            for (Map.Entry<String, String> e : colorMap.entrySet()) {
                String vName = e.getValue();
                String vCaps = StringUtils.capitalize(vName);
                String vLow = vName.toLowerCase();
                if ("Any".equals(e.getKey())) {
                    for (Object c : (String)MagicColor.WUBRG) {
                        String cName = MagicColor.toLongString((byte)c);
                        String cNameCaps = StringUtils.capitalize(cName);
                        String cNameLow = cName.toLowerCase();
                        r = r.replaceAll(cNameCaps, vCaps);
                        r = r.replaceAll(cNameLow, vLow);
                    }
                    continue;
                }
                String cName = e.getKey();
                String cNameCaps = StringUtils.capitalize(cName);
                String cNameLow = cName.toLowerCase();
                r = r.replaceAll(cNameCaps, vCaps);
                r = r.replaceAll(cNameLow, vLow);
            }
            if (r.equals(o)) continue;
            toRemove.add(k);
            toAdd.add(r);
        }
        for (KeywordInterface k : toRemove) {
            result.getCurrentState().removeIntrinsicKeyword(k);
        }
        result.addIntrinsicKeywords(toAdd);
        result.getCurrentState().changeTextIntrinsic(colorMap, typeMap);
    }

    public static Card getProtoType(String script, SpellAbility sa, Player owner) {
        return TokenInfo.getProtoType(script, sa, owner, !sa.hasParam("LockTokenScript"));
    }

    public static Card getProtoType(String script, SpellAbility sa, Player owner, boolean applyTextChange) {
        String str;
        if (script == null || sa == null) {
            return null;
        }
        Card host = sa.getHostCard();
        Game game = host.getGame();
        String edition = ObjectUtils.firstNonNull(sa.getOriginalHost(), host).getSetCode();
        PaperToken token = StaticData.instance().getAllTokens().getToken(script, edition);
        if (token == null) {
            return null;
        }
        Card result = CardFactory.getCard(token, owner, game);
        if (sa.hasParam("TokenPower")) {
            str = sa.getParam("TokenPower");
            result.setBasePowerString(str);
            result.setBasePower(AbilityUtils.calculateAmount(host, str, sa));
        }
        if (sa.hasParam("TokenToughness")) {
            str = sa.getParam("TokenToughness");
            result.setBaseToughnessString(str);
            result.setBaseToughness(AbilityUtils.calculateAmount(host, str, sa));
        }
        if (applyTextChange) {
            TokenInfo.protoTypeApplyTextChange(result, sa);
        }
        if (sa.hasParam("TokenTypes")) {
            String types = sa.getParam("TokenTypes");
            types = types.replace("ChosenType", host.getChosenType());
            result.addType(types);
            result.setName(types);
        }
        if (sa.hasParam("TokenColors")) {
            String colors = sa.getParam("TokenColors");
            colors = colors.replace("ChosenColor", host.getChosenColor());
            result.setColor(colors.split(","));
        }
        return result;
    }
}

