/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import forge.game.card.CounterEnumType;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class CounterType
implements Comparable<CounterType>,
Serializable {
    private static final long serialVersionUID = -7575835723159144478L;
    private CounterEnumType eVal = null;
    private String sVal = null;
    static ImmutableList<String> keywordCounter = ImmutableList.of("Flying", "First Strike", "Double Strike", "Deathtouch", "Exalted", "Haste", "Hexproof", "Indestructible", "Lifelink", "Menace", "Reach", "Shadow", new String[]{"Trample", "Vigilance"});
    private static Map<CounterEnumType, CounterType> eMap = Maps.newEnumMap(CounterEnumType.class);
    private static Map<String, CounterType> sMap = Maps.newHashMap();

    private CounterType(CounterEnumType e, String s2) {
        this.eVal = e;
        this.sVal = s2;
    }

    public static CounterType get(CounterEnumType e) {
        if (!eMap.containsKey((Object)e)) {
            eMap.put(e, new CounterType(e, null));
        }
        return eMap.get((Object)e);
    }

    public static CounterType get(String s2) {
        if (!sMap.containsKey(s2)) {
            sMap.put(s2, new CounterType(null, s2));
        }
        return sMap.get(s2);
    }

    public static CounterType getType(String name) {
        if ("Any".equalsIgnoreCase(name)) {
            return null;
        }
        try {
            return CounterType.get(CounterEnumType.getType(name));
        }
        catch (IllegalArgumentException ex) {
            return CounterType.get(name);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eVal, this.sVal});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CounterType rhs = (CounterType)obj;
        return new EqualsBuilder().append((Object)this.eVal, (Object)rhs.eVal).append(this.sVal, rhs.sVal).isEquals();
    }

    public String toString() {
        return this.eVal != null ? this.eVal.toString() : this.sVal;
    }

    public String getName() {
        return this.eVal != null ? this.eVal.getName() : this.getKeywordDescription();
    }

    public String getCounterOnCardDisplayName() {
        return this.eVal != null ? this.eVal.getCounterOnCardDisplayName() : this.getKeywordDescription();
    }

    private String getKeywordDescription() {
        if (this.sVal.startsWith("Hexproof:")) {
            String[] k = this.sVal.split(":");
            return "Hexproof from " + k[2];
        }
        if (this.sVal.startsWith("Trample:")) {
            return "Trample over Planeswalkers";
        }
        return this.sVal;
    }

    @Override
    public int compareTo(CounterType o) {
        return ComparisonChain.start().compare(this.eVal, o.eVal, Ordering.natural().nullsLast()).compare(this.sVal, o.sVal, Ordering.natural().nullsLast()).result();
    }

    public boolean is(CounterEnumType eType) {
        return this.eVal == eType;
    }

    public boolean isKeywordCounter() {
        if (this.eVal != null) {
            return false;
        }
        if (this.sVal.startsWith("Hexproof:")) {
            return true;
        }
        if (this.sVal.startsWith("Trample:")) {
            return true;
        }
        return keywordCounter.contains(this.sVal);
    }

    public int getRed() {
        return this.eVal != null ? this.eVal.getRed() : 255;
    }

    public int getGreen() {
        return this.eVal != null ? this.eVal.getGreen() : 255;
    }

    public int getBlue() {
        return this.eVal != null ? this.eVal.getBlue() : 255;
    }
}

