/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.game.CardTraitBase;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.combat.CombatUtil;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.PredicateString;
import forge.util.collect.FCollectionView;
import java.util.Comparator;

public final class CardPredicates {
    public static Predicate<Card> isController(Player p) {
        return c -> c.getController().equals(p);
    }

    public static Predicate<Card> isControlledByAnyOf(FCollectionView<Player> pList) {
        return c -> pList.contains(c.getController());
    }

    public static Predicate<Card> isOwner(Player p) {
        return c -> p.equals(c.getOwner());
    }

    public static Predicate<Card> ownerLives() {
        return c -> !c.getOwner().hasLost();
    }

    public static Predicate<Card> isType(String cardType) {
        return c -> c.getType().hasStringType(cardType);
    }

    public static Predicate<Card> hasKeyword(String keyword) {
        return c -> c.hasKeyword(keyword);
    }

    public static Predicate<Card> hasKeyword(Keyword keyword) {
        return c -> c.hasKeyword(keyword);
    }

    public static Predicate<Card> containsKeyword(String keyword) {
        return c -> {
            if (Iterables.any(c.getHiddenExtrinsicKeywords(), PredicateString.contains(keyword))) {
                return true;
            }
            for (KeywordInterface k : c.getKeywords()) {
                if (!k.getOriginal().contains(keyword)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<Card> isTargetableBy(SpellAbility source) {
        return source::canTarget;
    }

    public static Predicate<Card> nameEquals(String name) {
        return c -> c.getName().equals(name);
    }

    public static Predicate<Card> sharesNameWith(Card name) {
        return c -> c.sharesNameWith(name);
    }

    public static Predicate<Card> sharesCMCWith(Card cmc) {
        return c -> c.sharesCMCWith(cmc);
    }

    public static Predicate<Card> sharesColorWith(Card color) {
        return c -> c.sharesColorWith(color);
    }

    public static Predicate<Card> sharesControllerWith(Card card) {
        return c -> c.sharesControllerWith(card);
    }

    public static Predicate<Card> sharesCardTypeWith(Card card) {
        return c -> c.sharesCardTypeWith(card);
    }

    public static Predicate<Card> sharesAllCardTypesWith(Card card) {
        return c -> c.sharesAllCardTypesWith(card);
    }

    public static Predicate<Card> sharesCreatureTypeWith(Card card) {
        return c -> c.sharesCreatureTypeWith(card);
    }

    public static Predicate<Card> sharesLandTypeWith(Card card) {
        return c -> c.sharesLandTypeWith(card);
    }

    public static Predicate<Card> possibleBlockers(Card attacker) {
        return c -> c.isCreature() && CombatUtil.canBlock(attacker, c);
    }

    public static Predicate<Card> possibleBlockerForAtLeastOne(Iterable<Card> attackers) {
        return c -> c.isCreature() && CombatUtil.canBlockAtLeastOne(c, attackers);
    }

    public static Predicate<Card> restriction(String[] restrictions, Player sourceController, Card source, CardTraitBase spellAbility) {
        return c -> c != null && c.isValid(restrictions, sourceController, source, spellAbility);
    }

    public static Predicate<Card> restriction(String restrictions, Player sourceController, Card source, CardTraitBase spellAbility) {
        return c -> c != null && c.isValid(restrictions, sourceController, source, spellAbility);
    }

    public static Predicate<Card> canBeSacrificedBy(SpellAbility sa, boolean effect) {
        return c -> c.canBeSacrificedBy(sa, effect);
    }

    public static Predicate<Card> canExiledBy(SpellAbility sa, boolean effect) {
        return c -> c.canExiledBy(sa, effect);
    }

    public static Predicate<Card> canBeAttached(Card aura, SpellAbility sa) {
        return c -> c.canBeAttached(aura, sa);
    }

    public static Predicate<Card> isColor(byte color) {
        return c -> c.getColor().hasAnyColor(color);
    }

    public static Predicate<Card> isExactlyColor(byte color) {
        return c -> c.getColor().hasExactlyColor(color);
    }

    public static Predicate<Card> isColorless() {
        return c -> c.getColor().isColorless();
    }

    public static Predicate<Card> isEquippedBy(String name) {
        return c -> c.isEquippedBy(name);
    }

    public static Predicate<Card> isEnchantedBy(String name) {
        return c -> c.isEnchantedBy(name);
    }

    public static Predicate<Card> hasCMC(int cmc) {
        return c -> c.sharesCMCWith(cmc);
    }

    public static Predicate<Card> greaterCMC(int cmc) {
        return c -> c.getCMC() >= cmc;
    }

    public static Predicate<Card> lessCMC(int cmc) {
        return c -> c.getCMC() <= cmc;
    }

    public static Predicate<Card> evenCMC() {
        return c -> c.getCMC() % 2 == 0;
    }

    public static Predicate<Card> oddCMC() {
        return c -> c.getCMC() % 2 == 1;
    }

    public static Predicate<Card> hasSuspend() {
        return Card::hasSuspend;
    }

    public static Predicate<Card> hasCounters() {
        return GameEntity::hasCounters;
    }

    public static Predicate<Card> hasCounter(CounterType type) {
        return CardPredicates.hasCounter(type, 1);
    }

    public static Predicate<Card> hasCounter(CounterEnumType type) {
        return CardPredicates.hasCounter(type, 1);
    }

    public static Predicate<Card> hasCounter(CounterType type, int n) {
        return c -> c.getCounters(type) >= n;
    }

    public static Predicate<Card> hasCounter(CounterEnumType type, int n) {
        return CardPredicates.hasCounter(CounterType.get(type), n);
    }

    public static Predicate<Card> hasLessCounter(CounterType type, int n) {
        return c -> {
            int x = c.getCounters(type);
            return x > 0 && x <= n;
        };
    }

    public static Predicate<Card> hasLessCounter(CounterEnumType type, int n) {
        return CardPredicates.hasLessCounter(CounterType.get(type), n);
    }

    public static Predicate<Card> canReceiveCounters(CounterType counter) {
        return c -> c.canReceiveCounters(counter);
    }

    public static Predicate<Card> canReceiveCounters(CounterEnumType counter) {
        return CardPredicates.canReceiveCounters(CounterType.get(counter));
    }

    public static Predicate<Card> hasGreaterPowerThan(int minPower) {
        return c -> c.getNetPower() > minPower;
    }

    public static Comparator<Card> compareByCounterType(CounterType type) {
        return Comparator.comparingInt(arg0 -> arg0.getCounters(type));
    }

    public static Comparator<Card> compareByCounterType(CounterEnumType type) {
        return CardPredicates.compareByCounterType(CounterType.get(type));
    }

    public static Predicate<Card> hasSVar(String name) {
        return c -> c.hasSVar(name);
    }

    public static Predicate<Card> isExiledWith(Card card) {
        return c -> card.equals(c.getExiledWith());
    }

    public static Comparator<Card> compareByGameTimestamp() {
        return Comparator.comparingLong(Card::getGameTimestamp);
    }

    public static Predicate<Card> inZone(ZoneType zt) {
        return c -> {
            Zone z = c.getLastKnownZone();
            return z != null && z.is(zt);
        };
    }

    public static Predicate<Card> inZone(Iterable<ZoneType> zt) {
        return c -> {
            Zone z = c.getLastKnownZone();
            if (z != null) {
                for (ZoneType t2 : zt) {
                    if (!z.is(t2)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static Predicate<Card> isRemAIDeck() {
        return c -> c.getRules() != null && c.getRules().getAiHints().getRemAIDecks();
    }

    public static Predicate<Card> castSA(Predicate<SpellAbility> predSA) {
        return c -> {
            if (c.getCastSA() == null) {
                return false;
            }
            return predSA.apply(c.getCastSA());
        };
    }

    public static Predicate<Card> phasedIn() {
        return c -> !c.isPhasedOut();
    }

    public static Predicate<Card> isAttractionWithLight(int light) {
        return c -> c.isAttraction() && c.getAttractionLights().contains(light);
    }

    public static class Presets {
        public static final Predicate<Card> TAPPED = Card::isTapped;
        public static final Predicate<Card> FACE_DOWN = Card::isFaceDown;
        public static final Predicate<Card> UNTAPPED = Card::isUntapped;
        public static final Predicate<Card> CAN_TAP = Card::canTap;
        public static final Predicate<Card> CAN_CREW = Card::canCrew;
        public static final Predicate<Card> CREATURES = Card::isCreature;
        public static final Predicate<Card> ENCHANTMENTS = Card::isEnchantment;
        public static final Predicate<Card> AURA = Card::isAura;
        public static final Predicate<Card> EQUIPMENT = Card::isEquipment;
        public static final Predicate<Card> FORTIFICATION = Card::isFortification;
        public static final Predicate<Card> CURSE = Card::isCurse;
        public static final Predicate<Card> UNENCHANTED = c -> !c.isEnchanted();
        public static final Predicate<Card> ENCHANTED = GameEntity::isEnchanted;
        public static final Predicate<Card> NON_TOKEN = c -> !c.isToken() && !c.isTokenCard();
        public static final Predicate<Card> TOKEN = c -> c.isToken() || c.isTokenCard();
        public static final Predicate<Card> BASIC_LANDS = c -> c.isLand() && c.isBasicLand();
        public static final Predicate<Card> ARTIFACTS = Card::isArtifact;
        public static final Predicate<Card> NON_ARTIFACTS = c -> !c.isArtifact();
        public static final Predicate<Card> LANDS = c -> c.isLand();
        public static final Predicate<Card> LANDS_PRODUCING_MANA = c -> c.isBasicLand() || c.isLand() && !c.getManaAbilities().isEmpty();
        public static final Predicate<Card> PERMANENTS = Card::isPermanent;
        public static final Predicate<Card> NONLAND_PERMANENTS = c -> c.isPermanent() && !c.isLand();
        public static final Predicate<Card> hasFirstStrike = c -> c.isCreature() && (c.hasFirstStrike() || c.hasDoubleStrike());
        public static final Predicate<Card> hasSecondStrike = c -> c.isCreature() && (!c.hasFirstStrike() || c.hasDoubleStrike());
        public static final Predicate<Card> SNOW_LANDS = c -> c.isLand() && c.isSnow();
        public static final Predicate<Card> PLANESWALKERS = Card::isPlaneswalker;
        public static final Predicate<Card> BATTLES = Card::isBattle;
        public static final Predicate<Card> CAN_BE_DESTROYED = Card::canBeDestroyed;
        public static final Predicate<Card> ATTRACTIONS = Card::isAttraction;
    }
}

