/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.GameObjectPredicates;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.event.GameEventPlayerStatsChanged;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CardDamageMap
extends ForwardingTable<Card, GameEntity, Integer> {
    private Table<Card, GameEntity, Integer> dataMap = HashBasedTable.create();

    public CardDamageMap(Table<Card, GameEntity, Integer> damageMap) {
        this.putAll(damageMap);
    }

    public CardDamageMap() {
    }

    public void triggerPreventDamage(boolean isCombat) {
        for (Map.Entry e : this.columnMap().entrySet()) {
            int sum = 0;
            Iterator iterator = e.getValue().values().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                sum += i;
            }
            if (sum <= 0) continue;
            GameEntity ge = (GameEntity)e.getKey();
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.DamageTarget, ge);
            runParams.put(AbilityKey.DamageAmount, Integer.valueOf(sum));
            runParams.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
            ge.getGame().getTriggerHandler().runTrigger(TriggerType.DamagePreventedOnce, runParams, false);
            ge.getView().updatePreventNextDamage(ge);
            if (!(ge instanceof Player)) continue;
            ge.getGame().fireEvent(new GameEventPlayerStatsChanged((Player)ge, false));
        }
    }

    public void triggerDamageDoneOnce(boolean isCombat, Game game) {
        for (Map.Entry entry : this.rowMap().entrySet()) {
            Card sourceLKI = (Card)entry.getKey();
            int sum = 0;
            for (Integer n : entry.getValue().values()) {
                sum += n.intValue();
            }
            if (sum <= 0) continue;
            EnumMap<AbilityKey, Card> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.DamageSource, sourceLKI);
            runParams.put(AbilityKey.DamageMap, (Card)((Object)Maps.newHashMap(entry.getValue())));
            runParams.put(AbilityKey.IsCombatDamage, (Card)((Object)Boolean.valueOf(isCombat)));
            game.getTriggerHandler().runTrigger(TriggerType.DamageDealtOnce, (Map<AbilityKey, Object>)runParams, false);
        }
        for (Map.Entry entry : this.columnMap().entrySet()) {
            int sum = 0;
            PlayerCollection controllers = new PlayerCollection();
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                sum += ((Integer)entry2.getValue()).intValue();
                controllers.add(((Card)entry2.getKey()).getController());
            }
            if (sum > 0) {
                GameEntity ge = (GameEntity)entry.getKey();
                EnumMap<AbilityKey, Object> enumMap = AbilityKey.newMap();
                enumMap.put(AbilityKey.DamageTarget, ge);
                enumMap.put(AbilityKey.DamageMap, Maps.newHashMap(entry.getValue()));
                enumMap.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
                game.getTriggerHandler().runTrigger(TriggerType.DamageDoneOnce, enumMap, false);
            }
            for (Player player : controllers) {
                GameEntity ge = (GameEntity)entry.getKey();
                EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                runParams.put(AbilityKey.DamageTarget, ge);
                runParams.put(AbilityKey.DamageSource, player);
                runParams.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
                game.getTriggerHandler().runTrigger(TriggerType.DamageDoneOnceByController, runParams, false);
            }
        }
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.DamageMap, new CardDamageMap(this));
        runParams.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
        game.getTriggerHandler().runTrigger(TriggerType.DamageAll, runParams, false);
    }

    public void triggerExcessDamage(boolean isCombat, Map<Card, Integer> lethalDamage, Game game, SpellAbility cause, Map<Integer, Card> lkiCache) {
        int storedExcess = 0;
        CardCollection damagedList = new CardCollection();
        for (Map.Entry<Card, Integer> damaged : lethalDamage.entrySet()) {
            int sum = 0;
            for (Integer i : this.column((GameEntity)damaged.getKey()).values()) {
                sum += i.intValue();
            }
            if (sum == 0) continue;
            int excess = sum - (damaged.getKey().hasBeenDealtDeathtouchDamage() ? 1 : damaged.getValue());
            lkiCache.get(damaged.getKey().getId()).setHasBeenDealtExcessDamageThisTurn(excess > 0);
            if (excess <= 0) continue;
            if (!(cause == null || !cause.hasParam("ExcessSVar") || cause.hasParam("ExcessSVarCondition") && !damaged.getKey().isValid(cause.getParam("ExcessSVarCondition"), cause.getActivatingPlayer(), cause.getHostCard(), (CardTraitBase)cause) || cause.hasParam("ExcessSVarTargeted") && !damaged.getKey().equals(cause.getTargetCard()))) {
                storedExcess += excess;
            }
            damaged.getKey().setHasBeenDealtExcessDamageThisTurn(true);
            damaged.getKey().logExcessDamage(excess);
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.DamageTarget, damaged.getKey());
            runParams.put(AbilityKey.DamageAmount, Integer.valueOf(excess));
            runParams.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
            game.getTriggerHandler().runTrigger(TriggerType.ExcessDamage, runParams, false);
            damagedList.add(damaged.getKey());
        }
        if (cause != null && cause.hasParam("ExcessSVar")) {
            cause.setSVar(cause.getParam("ExcessSVar"), Integer.toString(storedExcess));
        }
        if (!damagedList.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.DamageTargets, damagedList);
            runParams.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
            game.getTriggerHandler().runTrigger(TriggerType.ExcessDamageAll, runParams, false);
        }
    }

    @Override
    public Integer put(Card rowKey, GameEntity columnKey, Integer value) {
        Integer old = this.contains(rowKey, columnKey) ? (Integer)this.get(rowKey, columnKey) : 0;
        return this.dataMap.put(rowKey, columnKey, value + old);
    }

    @Override
    protected Table<Card, GameEntity, Integer> delegate() {
        return this.dataMap;
    }

    public int totalAmount() {
        int result = 0;
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            result += i;
        }
        return result;
    }

    public CardDamageMap filteredMap(String validSource, String validTarget, Card host, CardTraitBase sa) {
        CardDamageMap result = new CardDamageMap();
        HashSet<GameObject> filteredSource = null;
        HashSet<GameObject> filteredTarget = null;
        if (validSource != null) {
            filteredSource = Sets.newHashSet(Iterables.filter(this.rowKeySet(), GameObjectPredicates.restriction(validSource.split(","), host.getController(), host, sa)));
        }
        if (validTarget != null) {
            filteredTarget = Sets.newHashSet(Iterables.filter(this.columnKeySet(), GameObjectPredicates.restriction(validTarget.split(","), host.getController(), host, sa)));
        }
        for (Table.Cell c : this.cellSet()) {
            if (filteredSource != null && !filteredSource.contains(c.getRowKey()) || filteredTarget != null && !filteredTarget.contains(c.getColumnKey())) continue;
            result.put((Card)c.getRowKey(), (GameEntity)c.getColumnKey(), (Integer)c.getValue());
        }
        return result;
    }
}

