/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;

public class CardCollection
extends FCollection<Card>
implements CardCollectionView {
    private static final long serialVersionUID = -8133537013727100275L;
    public static final CardCollectionView EMPTY = new EmptyCardCollection();

    public static CardCollectionView getView(Iterable<Card> cards) {
        return CardCollection.getView(cards, false);
    }

    public static CardCollectionView getView(Iterable<Card> cards, boolean allowModify) {
        if (cards == null) {
            return EMPTY;
        }
        if (allowModify) {
            return new CardCollection(cards);
        }
        if (cards instanceof CardCollectionView) {
            return (CardCollectionView)cards;
        }
        return new CardCollection(cards);
    }

    public static CardCollectionView combine(CardCollectionView ... views) {
        if (views == null) {
            throw new NullPointerException("The 'views' parameter was null when CardCollection.combine was called");
        }
        FCollection newCol = null;
        FCollectionView<Card> viewWithCards = null;
        for (CardCollectionView v : views) {
            if (v.isEmpty()) continue;
            if (viewWithCards == null) {
                viewWithCards = v;
                continue;
            }
            if (newCol == null) {
                newCol = new CardCollection((Iterable<Card>)viewWithCards);
                newCol.addAll(v);
                viewWithCards = newCol;
                continue;
            }
            newCol.addAll(v);
        }
        if (viewWithCards == null) {
            viewWithCards = EMPTY;
        }
        return viewWithCards;
    }

    public CardCollection() {
    }

    public CardCollection(Card card) {
        super(card);
    }

    public CardCollection(Iterable<Card> cards) {
        super(cards);
    }

    public CardCollection subList(int fromIndex, int toIndex) {
        return new CardCollection((Iterable<Card>)super.subList(fromIndex, toIndex));
    }

    private static final class EmptyCardCollection
    extends FCollection.EmptyFCollection<Card>
    implements CardCollectionView {
        private static final long serialVersionUID = -3218771134502034727L;

        private EmptyCardCollection() {
        }
    }
}

