/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import forge.card.CardStateName;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardState;
import java.util.Map;

public class CardCloneStates
extends ForwardingMap<CardStateName, CardState> {
    private Map<CardStateName, CardState> dataMap = Maps.newEnumMap(CardStateName.class);
    private Card origin;
    private CardTraitBase ctb;

    public CardCloneStates(Card origin, CardTraitBase sa) {
        this.origin = origin;
        this.ctb = sa;
    }

    public Card getOrigin() {
        return this.origin;
    }

    public CardTraitBase getSource() {
        return this.ctb;
    }

    public Card getHost() {
        return this.ctb.getHostCard();
    }

    @Override
    protected Map<CardStateName, CardState> delegate() {
        return this.dataMap;
    }

    public CardState get(CardStateName key) {
        if (this.dataMap.containsKey((Object)key)) {
            return (CardState)super.get((Object)key);
        }
        CardState original = (CardState)super.get((Object)CardStateName.Original);
        CardState result = new CardState(original.getCard(), key);
        result.copyFrom(original, false);
        this.dataMap.put(key, result);
        return result;
    }

    public CardCloneStates copy(Card host, boolean lki) {
        CardCloneStates result = new CardCloneStates(this.origin, this.ctb);
        for (Map.Entry<CardStateName, CardState> e : this.dataMap.entrySet()) {
            result.put(e.getKey(), e.getValue().copy(host, e.getKey(), lki));
        }
        return result;
    }
}

