/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.EnumMap;

public class ZoneExchangeEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card object1 = sa.hasParam("Object") ? (Card)AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Object"), sa).get(false) : sa.getHostCard();
        return "Exchange a " + sa.getParam("Type") + " in " + sa.getParam("Zone2") + " with " + object1;
    }

    @Override
    public void resolve(SpellAbility sa) {
        String filter;
        Card source = sa.getHostCard();
        Player p = sa.getActivatingPlayer();
        Game game = p.getGame();
        String type = sa.getParam("Type");
        String valid = sa.getParam("ValidExchange");
        ZoneType zone1 = sa.hasParam("Zone1") ? ZoneType.smartValueOf(sa.getParam("Zone1")) : ZoneType.Battlefield;
        ZoneType zone2 = sa.hasParam("Zone2") ? ZoneType.smartValueOf(sa.getParam("Zone2")) : ZoneType.Hand;
        Card object1 = null;
        object1 = sa.hasParam("Object") ? (Card)AbilityUtils.getDefinedCards(source, sa.getParam("Object"), sa).get(false) : source;
        if (object1 == null || !object1.isInZone(zone1) || !object1.getOwner().equals(p)) {
            return;
        }
        CardCollection list = new CardCollection(p.getCardsIn(zone2));
        if (type != null) {
            if (!object1.getType().hasStringType(type)) {
                return;
            }
            filter = type;
        } else {
            filter = valid != null ? valid : "Card";
        }
        list = CardLists.getValidCards((Iterable<Card>)list, filter, p, source, (CardTraitBase)sa);
        if (list.isEmpty()) {
            return;
        }
        Card object2 = p.getController().chooseSingleEntityForEffect(list, sa, Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]), !sa.hasParam("Mandatory"), null);
        if (object2 == null || !object2.isInZone(zone2) || type != null && !object2.getType().hasStringType(type)) {
            return;
        }
        Card c = null;
        if (type != null && type.equals("Aura") && object1.getEnchantingCard() != null && !(c = object1.getEnchantingCard()).canBeAttached(object2, sa)) {
            return;
        }
        if (c != null) {
            object1.unattachFromEntity(c);
            object2.attachToEntity(c, sa);
        }
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, sa.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, sa.getLastStateGraveyard());
        Card newObj1 = game.getAction().moveTo(zone2, object1, sa, moveParams);
        Card newObj2 = game.getAction().moveTo(zone1, object2, sa, moveParams);
        CardZoneTable table = new CardZoneTable();
        table.put(zone1, newObj1.getZone().getZoneType(), newObj1);
        table.put(zone2, newObj2.getZone().getZoneType(), newObj2);
        table.triggerChangesZoneAll(game, sa);
    }
}

