/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;

public class VillainousChoiceEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        ArrayList<SpellAbility> abilities = Lists.newArrayList(sa.getAdditionalAbilityList("Choices"));
        int amount = this.extractAmount(sa);
        String prompt = sa.getParamOrDefault("ChoicePrompt", "Villainous Choice by " + sa.getActivatingPlayer());
        Card source = sa.getHostCard();
        for (Player p : VillainousChoiceEffect.getDefinedPlayersOrTargeted(sa)) {
            int choiceAmount = p.getAdditionalVillainousChoices() + 1;
            ArrayList<SpellAbility> chosenSAs = Lists.newArrayList();
            for (int i = 0; i < choiceAmount; ++i) {
                chosenSAs.addAll(p.getController().chooseSpellAbilitiesForEffect(abilities, sa, prompt, amount, ImmutableMap.of()));
            }
            for (SpellAbility chosenSA : chosenSAs) {
                source.addRemembered(p);
                AbilityUtils.resolve(chosenSA);
                source.removeRemembered(p);
            }
        }
    }
}

