/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumMap;
import java.util.HashMap;

public class UntapEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Untap ");
        if (sa.hasParam("UntapUpTo")) {
            sb.append("up to ").append(sa.getParam("Amount")).append(" ");
            sb.append(sa.getParam("UntapType")).append("s");
        } else {
            sb.append(Lang.joinHomogenous(UntapEffect.getTargetCards(sa)));
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        boolean etb = sa.hasParam("ETB");
        if (sa.hasParam("UntapUpTo")) {
            UntapEffect.untapChoose(sa, false);
        } else if (sa.hasParam("UntapExactly")) {
            UntapEffect.untapChoose(sa, true);
        } else {
            CardCollection affectedCards = UntapEffect.getTargetCards(sa);
            affectedCards.addAll(CardUtil.getRadiance(sa));
            CardCollection untapped = new CardCollection();
            for (Card tgtC : affectedCards) {
                if (tgtC.isPhasedOut()) continue;
                if (tgtC.isInPlay() && tgtC.untap(true)) {
                    untapped.add(tgtC);
                }
                if (!etb) continue;
                tgtC.setTapped(false);
            }
            if (!untapped.isEmpty() && !etb) {
                EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                HashMap<Player, CardCollection> map = Maps.newHashMap();
                map.put(activator, untapped);
                runParams.put(AbilityKey.Map, map);
                activator.getGame().getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
            }
        }
    }

    private static void untapChoose(SpellAbility sa, boolean mandatory) {
        HashMap<Player, CardCollection> map = Maps.newHashMap();
        int num = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa);
        String valid = sa.getParam("UntapType");
        for (Player p : AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa)) {
            CardCollectionView selected;
            CardCollection untapped = new CardCollection();
            if (!p.isInGame()) continue;
            CardCollection list = CardLists.getValidCards((Iterable<Card>)p.getGame().getCardsIn(ZoneType.Battlefield), valid, sa.getActivatingPlayer(), sa.getHostCard(), (CardTraitBase)sa);
            if (!mandatory) {
                list = CardLists.filter((Iterable<Card>)list, CardPredicates.Presets.TAPPED);
            }
            if ((selected = p.getController().chooseCardsForEffect(list, sa, Localizer.getInstance().getMessage("lblSelectCardToUntap", new Object[0]), mandatory ? num : 0, num, !mandatory, null)) != null) {
                for (Card c : selected) {
                    if (!c.untap(true)) continue;
                    untapped.add(c);
                }
            }
            if (untapped.isEmpty()) continue;
            map.put(p, untapped);
        }
        if (!map.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Map, map);
            sa.getActivatingPlayer().getGame().getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
        }
    }
}

