/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.HashMap;

public class TimeTravelEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "Time travel. (For each suspended card you own and each permanent you control with a time counter on it, you may add or remove a time counter.)";
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int num = sa.hasParam("Amount") ? AbilityUtils.calculateAmount(host, sa.getParam("Amount"), sa) : 1;
        PlayerController pc = activator.getController();
        CounterEnumType counterType = CounterEnumType.TIME;
        for (int i = 0; i < num; ++i) {
            FCollection<Card> list = new FCollection<Card>();
            list.addAll(CardLists.filter((Iterable<Card>)activator.getCardsIn(ZoneType.Exile), CardPredicates.hasSuspend()));
            list.addAll(CardLists.filter((Iterable<Card>)activator.getCardsIn(ZoneType.Battlefield), CardPredicates.hasCounter(counterType)));
            GameEntityCounterTable table = new GameEntityCounterTable();
            String prompt = Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]);
            for (Card c : pc.chooseEntitiesForEffect(list, 0, list.size(), null, sa, prompt, activator, null)) {
                HashMap<String, Object> params = Maps.newHashMap();
                params.put("Target", c);
                params.put("CounterType", (Object)counterType);
                prompt = Localizer.getInstance().getMessage("lblWhatToDoWithTargetCounter", counterType.getName(), CardTranslation.getTranslatedName(c.getName())) + " ";
                boolean putCounter = pc.chooseBinary(sa, prompt, PlayerController.BinaryChoiceType.AddOrRemove, params);
                if (putCounter) {
                    c.addCounter(counterType, 1, activator, table);
                    continue;
                }
                c.subtractCounter(counterType, 1, activator);
            }
            table.replaceCounterEffect(game, sa, true);
        }
    }
}

