/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumMap;
import java.util.HashMap;

public class TapOrUntapEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Tap or untap ");
        sb.append(Lang.joinHomogenous(TapOrUntapEffect.getTargetCards(sa)));
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        EnumMap<AbilityKey, Object> runParams;
        Player tapper = sa.getActivatingPlayer();
        if (sa.hasParam("Tapper")) {
            tapper = (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Tapper"), sa).getFirst();
        }
        PlayerController pc = tapper.getController();
        CardCollection tapped = new CardCollection();
        HashMap<Player, CardCollection> untapMap = Maps.newHashMap();
        for (Card tgtC : TapOrUntapEffect.getTargetCards(sa)) {
            if (!tgtC.isInPlay() || tgtC.isPhasedOut()) continue;
            boolean tap = pc.chooseBinary(sa, Localizer.getInstance().getMessage("lblTapOrUntapTarget", CardTranslation.getTranslatedName(tgtC.getName())), PlayerController.BinaryChoiceType.TapOrUntap, !tgtC.getController().equals(tapper));
            if (tap) {
                if (!tgtC.tap(true, sa, tapper)) continue;
                tapped.add(tgtC);
                continue;
            }
            if (!tgtC.untap(true)) continue;
            untapMap.computeIfAbsent(tapper, i -> new CardCollection()).add(tgtC);
        }
        if (!untapMap.isEmpty()) {
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Map, untapMap);
            tapper.getGame().getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
        }
        if (!tapped.isEmpty()) {
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, tapped);
            tapper.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
    }
}

