/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.SpellAbilityEffect;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;

public class TakeInitiativeEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = TakeInitiativeEffect.getTargetPlayers(sa);
        sb.append(Lang.joinHomogenous(tgtPlayers)).append(tgtPlayers.size() == 1 ? " takes" : " take");
        sb.append(" the initiative.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        String set = sa.getHostCard().getSetCode();
        for (Player p : TakeInitiativeEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            p.getGame().getAction().takeInitiative(p, set);
        }
    }
}

