/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.event.GameEventCombatChanged;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.ArrayList;
import java.util.EnumMap;

public class SwitchBlockEffect
extends SpellAbilityEffect {
    private void runTriggers(Game game, Card attacker, Card blocker) {
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Attacker, attacker);
        runParams.put(AbilityKey.Blocker, blocker);
        game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedByCreature, runParams, false);
        game.getTriggerHandler().runTrigger(TriggerType.Blocks, runParams, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        Combat combat = game.getPhaseHandler().getCombat();
        boolean isTargetingAttacker = false;
        ArrayList<Object> attackers = new ArrayList<Object>();
        if (sa.hasParam("DefinedAttacker")) {
            String definedAttacker = sa.getParam("DefinedAttacker");
            if (definedAttacker.equals("Targeted")) {
                isTargetingAttacker = true;
            }
            for (Object attacker : AbilityUtils.getDefinedCards(host, definedAttacker, sa)) {
                if (!combat.isAttacking((Card)attacker)) continue;
                attackers.add(attacker);
            }
        }
        ArrayList<Card> blockers = new ArrayList<Card>();
        if (sa.hasParam("DefinedBlocker")) {
            String definedBlocker = sa.getParam("DefinedBlocker");
            if (definedBlocker.equals("Targeted")) {
                isTargetingAttacker = false;
            }
            for (Card blocker : AbilityUtils.getDefinedCards(host, definedBlocker, sa)) {
                if (!combat.isBlocking(blocker)) continue;
                blockers.add(blocker);
            }
        }
        if (attackers.isEmpty() || blockers.isEmpty()) {
            return;
        }
        boolean isReblock = sa.hasParam("RemoveFromCombat");
        if (isTargetingAttacker) {
            void var12_18;
            void var12_16;
            if (attackers.size() == 1) {
                return;
            }
            Card attacker1 = (Card)attackers.get(0);
            Card attacker2 = (Card)attackers.get(1);
            if (combat.getBandOfAttacker(attacker1) == combat.getBandOfAttacker(attacker2)) {
                return;
            }
            for (Card card : blockers) {
                if ((!combat.isBlocking(card, attacker1) || CombatUtil.canBlock(attacker2, card)) && (!combat.isBlocking(card, attacker2) || CombatUtil.canBlock(attacker1, card))) continue;
                return;
            }
            int[] blockingStates = new int[blockers.size()];
            boolean bl = false;
            while (var12_16 < blockers.size()) {
                Card blocker3 = (Card)blockers.get((int)var12_16);
                boolean blocking1 = combat.isBlocking(blocker3, attacker1);
                boolean blocking2 = combat.isBlocking(blocker3, attacker2);
                blockingStates[var12_16] = (blocking1 ? 1 : 0) + (blocking2 ? 2 : 0);
                combat.removeFromCombat(blocker3);
                ++var12_16;
            }
            combat.unregisterAttacker(attacker1, combat.getBandOfAttacker(attacker1));
            combat.unregisterAttacker(attacker2, combat.getBandOfAttacker(attacker2));
            boolean bl2 = false;
            while (var12_18 < blockers.size()) {
                Card blocker = (Card)blockers.get((int)var12_18);
                if ((blockingStates[var12_18] & 1) == 1) {
                    combat.addBlocker(attacker2, blocker);
                    if (isReblock) {
                        this.runTriggers(game, attacker2, blocker);
                    }
                }
                if ((blockingStates[var12_18] & 2) == 2) {
                    combat.addBlocker(attacker1, blocker);
                    if (isReblock) {
                        this.runTriggers(game, attacker1, blocker);
                    }
                }
                blocker.updateBlockingForView();
                ++var12_18;
            }
            combat.orderBlockersForDamageAssignment(attacker1, combat.getBlockers(attacker1));
            combat.orderBlockersForDamageAssignment(attacker2, combat.getBlockers(attacker2));
            for (Card blocker : blockers) {
                combat.orderAttackersForDamageAssignment(blocker);
            }
        } else {
            void var12_24;
            Card attacker;
            void var12_22;
            if (blockers.size() == 1) {
                return;
            }
            Card blocker1 = (Card)blockers.get(0);
            Card blocker2 = (Card)blockers.get(1);
            if (combat.getAttackersBlockedBy(blocker1).size() > blocker2.canBlockAdditional() + 1 || combat.getAttackersBlockedBy(blocker2).size() > blocker1.canBlockAdditional() + 1) {
                return;
            }
            for (Card card : attackers) {
                if ((!combat.isBlocking(blocker1, card) || CombatUtil.canBlock(card, blocker2)) && (!combat.isBlocking(blocker2, card) || CombatUtil.canBlock(card, blocker1))) continue;
                return;
            }
            Object blockingStates = new int[attackers.size()];
            boolean bl = false;
            while (var12_22 < attackers.size()) {
                attacker = (Card)attackers.get((int)var12_22);
                boolean blocking1 = combat.isBlocking(blocker1, attacker);
                boolean blocking2 = combat.isBlocking(blocker2, attacker);
                blockingStates[var12_22] = (blocking1 ? 1 : 0) + (blocking2 ? 2 : 0);
                ++var12_22;
            }
            combat.removeFromCombat(blocker1);
            combat.removeFromCombat(blocker2);
            boolean bl3 = false;
            while (var12_24 < attackers.size()) {
                attacker = (Card)attackers.get((int)var12_24);
                if ((blockingStates[var12_24] & 1) == 1) {
                    combat.addBlocker(attacker, blocker2);
                    if (isReblock) {
                        this.runTriggers(game, attacker, blocker2);
                    }
                }
                if ((blockingStates[var12_24] & 2) == 2) {
                    combat.addBlocker(attacker, blocker1);
                    if (isReblock) {
                        this.runTriggers(game, attacker, blocker1);
                    }
                }
                ++var12_24;
            }
            combat.orderAttackersForDamageAssignment(blocker1);
            combat.orderAttackersForDamageAssignment(blocker2);
        }
        game.updateCombatForView();
        game.fireEvent(new GameEventCombatChanged());
    }
}

