/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;

public class SkipTurnEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        int numTurns = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumTurns"), sa);
        for (Player player : SkipTurnEffect.getTargetPlayers(sa)) {
            sb.append(player).append(" ");
        }
        sb.append("skips his/her next ").append(numTurns).append(" turn(s).");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card hostCard = sa.getHostCard();
        Game game = hostCard.getGame();
        String name = hostCard + "'s Effect";
        String image = hostCard.getImageKey();
        int numTurns = AbilityUtils.calculateAmount(hostCard, sa.getParam("NumTurns"), sa);
        String repeffstr = "Event$ BeginTurn | ActiveZones$ Command | ValidPlayer$ You | Description$ Skip your next " + (numTurns > 1 ? Lang.getNumeral(numTurns) + " turns." : "turn.");
        String effect = "DB$ StoreSVar | SVar$ NumTurns | Type$ CountSVar | Expression$ NumTurns/Minus.1";
        String exile = "DB$ ChangeZone | Defined$ Self | Origin$ Command | Destination$ Exile | ConditionCheckSVar$ NumTurns | ConditionSVarCompare$ EQ0";
        for (Player player : SkipTurnEffect.getTargetPlayers(sa)) {
            Card eff = SkipTurnEffect.createEffect(sa, player, name, image);
            eff.setSVar("NumTurns", "Number$" + numTurns);
            SpellAbility calcTurn = AbilityFactory.getAbility(effect, eff);
            calcTurn.setSubAbility((AbilitySub)AbilityFactory.getAbility(exile, eff));
            ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
            re.setLayer(ReplacementLayer.Control);
            re.setOverridingAbility(calcTurn);
            eff.addReplacementEffect(re);
            game.getAction().moveToCommand(eff, sa);
        }
    }
}

