/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;

public class ScryEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection players = ScryEffect.getTargetPlayers(sa);
        sb.append(Lang.joinHomogenous(players)).append(" ");
        int num = 1;
        if (sa.hasParam("ScryNum")) {
            num = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("ScryNum"), sa);
        }
        sb.append(players.size() == 1 ? "scries " : "scry ").append(num).append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        int num = 1;
        if (sa.hasParam("ScryNum")) {
            num = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("ScryNum"), sa);
        }
        boolean isOptional = sa.hasParam("Optional");
        ArrayList<Player> players = Lists.newArrayList();
        for (Player p : ScryEffect.getTargetPlayers(sa)) {
            if (!p.isInGame() || isOptional && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWanttoScry", new Object[0]), null)) continue;
            players.add(p);
        }
        sa.getActivatingPlayer().getGame().getAction().scry(players, num, sa);
    }
}

