/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.PlanarDice;
import forge.game.ability.SpellAbilityEffect;
import forge.game.event.GameEventRollDie;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;

public class RollPlanarDiceEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        if (game.getActivePlanes() == null) {
            return;
        }
        if (sa.hasParam("SpecialAction")) {
            game.getPhaseHandler().incPlanarDiceSpecialActionThisTurn();
        }
        game.fireEvent(new GameEventRollDie());
        PlanarDice result = PlanarDice.roll(activator, null);
        String message = Localizer.getInstance().getMessage("lblPlanarDiceResult", result.toString());
        game.getAction().notifyOfValue(sa, activator, message, null);
    }
}

