/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.ability.effects.CopyPermanentEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.TokenCreateTable;
import forge.game.card.token.TokenInfo;
import forge.game.player.Player;
import forge.game.replacement.ReplacementResult;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ReplaceTokenEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Player p = sa.getActivatingPlayer();
        Game game = card.getGame();
        SpellAbility repSA = sa;
        if (repSA.getReplacingObjects().isEmpty()) {
            repSA = sa.getRootAbility();
        }
        Player affected = (Player)repSA.getReplacingObject(AbilityKey.Player);
        TokenCreateTable table = (TokenCreateTable)repSA.getReplacingObject(AbilityKey.Token);
        Map originalParams = (Map)repSA.getReplacingObject(AbilityKey.OriginalParams);
        if ("Amount".equals(sa.getParam("Type"))) {
            String mod = sa.getParamOrDefault("Amount", "Twice");
            for (Map.Entry e : table.row(affected).entrySet()) {
                if (!sa.matchesValidParam("ValidCard", e.getKey())) continue;
                int newAmt = AbilityUtils.doXMath((Integer)e.getValue(), mod, card, sa);
                table.put(affected, (Card)e.getKey(), newAmt);
            }
        } else if ("AddToken".equals(sa.getParam("Type"))) {
            long timestamp = game.getNextTimestamp();
            HashMap<Player, Integer> byController = Maps.newHashMap();
            for (Map.Entry entry : table.row(affected).entrySet()) {
                if (!sa.matchesValidParam("ValidCard", entry.getKey())) continue;
                Player player = ((Card)entry.getKey()).getController();
                int n = ObjectUtils.defaultIfNull((Integer)byController.get(player), 0);
                byController.put(player, n + (Integer)entry.getValue());
            }
            if (!byController.isEmpty()) {
                if (sa.hasParam("Amount")) {
                    int i = AbilityUtils.calculateAmount(card, sa.getParam("Amount"), sa);
                    for (Map.Entry entry : byController.entrySet()) {
                        entry.setValue(i);
                    }
                }
                for (Map.Entry entry : byController.entrySet()) {
                    for (String script : sa.getParam("TokenScript").split(",")) {
                        Card token = TokenInfo.getProtoType(script, sa, p);
                        if (token == null) {
                            throw new RuntimeException("don't find Token for TokenScript: " + script);
                        }
                        token.setTokenSpawningAbility((SpellAbility)repSA.getReplacingObject(AbilityKey.Cause));
                        token.setController((Player)entry.getKey(), timestamp);
                        table.put(p, token, (Integer)entry.getValue());
                    }
                }
            }
        } else if ("ReplaceToken".equals(sa.getParam("Type"))) {
            Card chosen = null;
            if (sa.hasParam("ValidChoices")) {
                CardCollection choices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("ValidChoices"), p, card, (CardTraitBase)sa);
                if (choices.isEmpty()) {
                    originalParams.put(AbilityKey.ReplacementResult, ReplacementResult.NotReplaced);
                    return;
                }
                chosen = p.getController().chooseSingleEntityForEffect(choices, sa, Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]), false, null);
            }
            long timestamp = game.getNextTimestamp();
            ArrayListMultimap<Player, ImmutablePair<Integer, Iterable<Object>>> toInsertMap = ArrayListMultimap.create();
            HashSet<Card> hashSet = Sets.newHashSet();
            for (Map.Entry entry : table.row(affected).entrySet()) {
                if (!sa.matchesValidParam("ValidCard", entry.getKey())) continue;
                Player controller = ((Card)entry.getKey()).getController();
                ImmutablePair<Integer, Iterable<Object>> tokenAmountPair = new ImmutablePair<Integer, Iterable<Object>>((Integer)entry.getValue(), ((Card)entry.getKey()).getRemembered());
                toInsertMap.put(controller, tokenAmountPair);
                hashSet.add((Card)entry.getKey());
            }
            table.row(affected).keySet().removeAll(hashSet);
            for (Map.Entry entry : toInsertMap.entries()) {
                int amt = (Integer)((Pair)entry.getValue()).getLeft();
                if (amt <= 0) continue;
                for (String script : sa.getParam("TokenScript").split(",")) {
                    Card token;
                    if (script.equals("Chosen")) {
                        token = CopyPermanentEffect.getProtoType(sa, chosen, (Player)entry.getKey());
                        token.setCopiedPermanent(token);
                    } else {
                        token = TokenInfo.getProtoType(script, sa, (Player)entry.getKey());
                    }
                    if (token == null) {
                        throw new RuntimeException("don't find Token for TokenScript: " + script);
                    }
                    token.setTokenSpawningAbility((SpellAbility)repSA.getReplacingObject(AbilityKey.Cause));
                    token.setController((Player)entry.getKey(), timestamp);
                    token.addRemembered((Iterable)((Pair)entry.getValue()).getRight());
                    table.put(affected, token, amt);
                }
            }
        } else if ("ReplaceController".equals(sa.getParam("Type"))) {
            long timestamp = game.getNextTimestamp();
            Player newController = p;
            if (sa.hasParam("NewController")) {
                newController = (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("NewController"), sa).get(false);
            }
            for (Map.Entry entry : table.row(affected).entrySet()) {
                if (!sa.matchesValidParam("ValidCard", entry.getKey())) continue;
                ((Card)entry.getKey()).setController(newController, timestamp);
            }
        }
        originalParams.put(AbilityKey.ReplacementResult, ReplacementResult.Updated);
    }
}

