/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.replacement.ReplacementResult;
import forge.game.spellability.SpellAbility;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ReplaceManaEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Player player = sa.getActivatingPlayer();
        if (!sa.isReplacementAbility()) {
            return;
        }
        Map params = (Map)sa.getReplacingObject(AbilityKey.OriginalParams);
        String replaced = (String)sa.getReplacingObject(AbilityKey.Mana);
        if (sa.hasParam("ReplaceMana")) {
            replaced = sa.getParam("ReplaceMana");
            if ("Any".equals(replaced)) {
                byte rs = player.getController().chooseColor("Choose a color", sa, ColorSet.ALL_COLORS);
                replaced = MagicColor.toShortString(rs);
            }
        } else if (sa.hasParam("ReplaceType")) {
            String color = sa.getParam("ReplaceType");
            if ("Any".equals(color)) {
                byte rs = player.getController().chooseColor("Choose a color", sa, ColorSet.ALL_COLORS);
                color = MagicColor.toShortString(rs);
            } else {
                color = MagicColor.toShortString(color);
            }
            for (byte c : MagicColor.WUBRGC) {
                String s2 = MagicColor.toShortString(c);
                replaced = replaced.replace(s2, color);
            }
        } else if (sa.hasParam("ReplaceColor")) {
            String color = sa.getParam("ReplaceColor");
            if ("Chosen".equals(color)) {
                if (card.hasChosenColor()) {
                    color = MagicColor.toShortString(card.getChosenColor());
                }
            } else {
                color = MagicColor.toShortString(color);
            }
            if (sa.hasParam("ReplaceOnly")) {
                replaced = replaced.replace(sa.getParam("ReplaceOnly"), color);
            } else {
                for (byte c : MagicColor.WUBRG) {
                    String s3 = MagicColor.toShortString(c);
                    replaced = replaced.replace(s3, color);
                }
            }
        } else if (sa.hasParam("ReplaceAmount")) {
            replaced = StringUtils.repeat(replaced, " ", Integer.parseInt(sa.getParam("ReplaceAmount")));
        }
        params.put(AbilityKey.Mana, replaced);
        params.put(AbilityKey.ReplacementResult, ReplacementResult.Updated);
    }
}

