/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.GameObject;
import forge.game.PlanarDice;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementResult;
import forge.game.spellability.SpellAbility;
import forge.util.collect.FCollection;
import java.util.Map;

public class ReplaceEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        AbilityKey varName = AbilityKey.fromString(sa.getParam("VarName"));
        String varValue = sa.getParam("VarValue");
        String type = sa.getParamOrDefault("VarType", "amount");
        Map params = (Map)sa.getReplacingObject(AbilityKey.OriginalParams);
        if ("Card".equals(type)) {
            CardCollection list = AbilityUtils.getDefinedCards(card, varValue, sa);
            if (list.size() > 0) {
                params.put(varName, list.get(0));
            }
        } else if ("Player".equals(type)) {
            PlayerCollection list = AbilityUtils.getDefinedPlayers(card, varValue, sa);
            if (list.size() > 0) {
                params.put(varName, list.get(0));
            }
        } else if ("GameEntity".equals(type)) {
            FCollection<GameObject> list = AbilityUtils.getDefinedObjects(card, varValue, sa);
            if (list.size() > 0) {
                params.put(varName, list.get(0));
            }
        } else if ("PlanarDice".equals(type)) {
            params.put(varName, PlanarDice.smartValueOf(varValue));
        } else if ("Map".equals(type)) {
            Map m4 = (Map)sa.getReplacingObject(varName);
            for (Player key : AbilityUtils.getDefinedPlayers(card, sa.getParam("VarKey"), sa)) {
                m4.put(key, m4.getOrDefault(key, 0) + AbilityUtils.calculateAmount(card, varValue, sa));
            }
        } else if (varName != null) {
            params.put(varName, AbilityUtils.calculateAmount(card, varValue, sa));
        }
        params.put(AbilityKey.ReplacementResult, ReplacementResult.Updated);
    }
}

