/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.replacement.ReplacementResult;
import forge.game.spellability.SpellAbility;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ReplaceDamageEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Game game = card.getGame();
        if (!sa.isReplacementAbility()) {
            return;
        }
        Map originalParams = (Map)sa.getReplacingObject(AbilityKey.OriginalParams);
        Integer dmg = (Integer)sa.getReplacingObject(AbilityKey.DamageAmount);
        String varValue = sa.getParamOrDefault("Amount", "1");
        int prevent = AbilityUtils.calculateAmount(card, varValue, sa);
        if (prevent > 0) {
            int n = Math.min(dmg, prevent);
            if (originalParams.get((Object)AbilityKey.DividedShieldAmount) != null) {
                n = Math.min(n, (Integer)originalParams.get((Object)AbilityKey.DividedShieldAmount));
            }
            dmg = dmg - n;
            prevent -= n;
            if (!StringUtils.isNumeric(varValue) && card.getSVar(varValue).startsWith("Number$")) {
                if (card.isImmutable() && prevent <= 0) {
                    game.getAction().exileEffect(card);
                } else {
                    card.setSVar(varValue, "Number$" + prevent);
                    card.updateAbilityTextForView();
                }
            }
            card.setSVar("PreventedDamage", "Number$" + n);
        }
        if (dmg <= 0) {
            originalParams.put(AbilityKey.ReplacementResult, ReplacementResult.Replaced);
            return;
        }
        originalParams.put(AbilityKey.DamageAmount, dmg);
        originalParams.put(AbilityKey.ReplacementResult, ReplacementResult.Updated);
    }
}

