/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import forge.util.Localizer;

public class RepeatEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "Repeat something. Somebody should really write a better StackDescription!";
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        SpellAbility repeat = sa.getAdditionalAbility("RepeatSubAbility");
        Integer maxRepeat = null;
        if (sa.hasParam("MaxRepeat") && (maxRepeat = Integer.valueOf(AbilityUtils.calculateAmount(source, sa.getParam("MaxRepeat"), sa))) == 0) {
            return;
        }
        int count = 0;
        do {
            AbilityUtils.resolve(repeat);
            if (maxRepeat == null || maxRepeat > ++count) continue;
            if (!source.getName().equals("Helm of Obedience")) break;
            StringBuilder infLoop = new StringBuilder(source.toString());
            infLoop.append(" - To avoid an infinite loop, this repeat has been broken ");
            infLoop.append(" and the game will now continue in the current state, ending the loop early. ");
            infLoop.append("Once Draws are available this probably should change to a Draw.");
            System.out.println(infLoop.toString());
            break;
        } while (RepeatEffect.checkRepeatConditions(sa));
    }

    private static boolean checkRepeatConditions(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        if (sa.hasParam("RepeatPresent")) {
            String repeatPresent = sa.getParam("RepeatPresent");
            String repeatCompare = sa.getParamOrDefault("RepeatCompare", "GE1");
            CardCollectionView list = sa.hasParam("RepeatDefined") ? AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("RepeatDefined"), sa) : game.getCardsIn(ZoneType.Battlefield);
            list = CardLists.getValidCards((Iterable<Card>)list, repeatPresent, activator, sa.getHostCard(), (CardTraitBase)sa);
            String rightString = repeatCompare.substring(2);
            int right = AbilityUtils.calculateAmount(sa.getHostCard(), rightString, sa);
            int left = list.size();
            if (!Expressions.compare(left, repeatCompare, right)) {
                return false;
            }
        }
        if (sa.hasParam("RepeatCheckSVar")) {
            int operandValue;
            int svarValue;
            String sVarOperator = "GE";
            String sVarOperand = "1";
            if (sa.hasParam("RepeatSVarCompare")) {
                sVarOperator = sa.getParam("RepeatSVarCompare").substring(0, 2);
                sVarOperand = sa.getParam("RepeatSVarCompare").substring(2);
            }
            if (!Expressions.compare(svarValue = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("RepeatCheckSVar"), sa), sVarOperator, operandValue = AbilityUtils.calculateAmount(sa.getHostCard(), sVarOperand, sa))) {
                return false;
            }
        }
        if (sa.hasParam("RepeatOptional")) {
            Player decider = sa.hasParam("RepeatOptionalDecider") ? (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("RepeatOptionalDecider"), sa).get(false) : activator;
            return decider.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantRepeatProcessAgain", new Object[0]), null);
        }
        return true;
    }
}

