/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardDamageMap;
import forge.game.card.CardLists;
import forge.game.card.CardUtil;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.ZoneType;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RepeatEachEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        boolean loopOverCards;
        Card source = sa.getHostCard();
        SpellAbility repeat = sa.getAdditionalAbility("RepeatSubAbility");
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        if (sa.hasParam("Optional") && sa.hasParam("OptionPrompt") && !activator.getController().confirmAction(sa, null, sa.getParam("OptionPrompt"), null)) {
            return;
        }
        boolean useImprinted = sa.hasParam("UseImprinted");
        FCollectionView repeatCards = null;
        ArrayList<SpellAbility> repeatSas = null;
        if (sa.hasParam("RepeatCards")) {
            ArrayList<ZoneType> zone = Lists.newArrayList();
            if (sa.hasParam("Zone")) {
                zone = ZoneType.listValueOf(sa.getParam("Zone"));
            } else {
                zone.add(ZoneType.Battlefield);
            }
            repeatCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(zone), sa.getParam("RepeatCards"), source.getController(), source, (CardTraitBase)sa);
        } else if (sa.hasParam("RepeatSpellAbilities")) {
            repeatSas = Lists.newArrayList();
            String[] restrictions = sa.getParam("RepeatSpellAbilities").split(",");
            for (SpellAbilityStackInstance stackInstance : game.getStack()) {
                if (!stackInstance.getSpellAbility().isValid(restrictions, source.getController(), source, (CardTraitBase)sa)) continue;
                repeatSas.add(stackInstance.getSpellAbility());
            }
        } else if (sa.hasParam("DefinedCards")) {
            repeatCards = AbilityUtils.getDefinedCards(source, sa.getParam("DefinedCards"), sa);
        }
        boolean bl = loopOverCards = repeatCards != null && !repeatCards.isEmpty();
        if (sa.hasParam("ClearRemembered")) {
            source.clearRemembered();
        }
        if (sa.hasParam("DamageMap")) {
            sa.setDamageMap(new CardDamageMap());
            sa.setPreventMap(new CardDamageMap());
            sa.setCounterTable(new GameEntityCounterTable());
        }
        if (sa.hasParam("ChangeZoneTable")) {
            sa.setChangeZoneTable(new CardZoneTable());
        }
        if (sa.hasParam("LoseLifeMap")) {
            sa.setLoseLifeMap(Maps.newHashMap());
        }
        if (loopOverCards) {
            if (sa.hasParam("ChooseOrder") && repeatCards.size() > 1) {
                Player chooser = sa.getParam("ChooseOrder").equals("True") ? activator : (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("ChooseOrder"), sa).get(false);
                repeatCards = chooser.getController().orderMoveToZoneList((CardCollectionView)repeatCards, ZoneType.None, sa);
            }
            for (GameObject card : repeatCards) {
                if (useImprinted) {
                    source.addImprintedCard((Card)card);
                } else {
                    source.addRemembered(card);
                }
                if (sa.hasParam("AmountFromVotes")) {
                    this.setVoteAmount(card, sa);
                }
                AbilityUtils.resolve(repeat);
                if (useImprinted) {
                    source.removeImprintedCard((Card)card);
                    continue;
                }
                source.removeRemembered(card);
            }
        }
        if (repeatSas != null) {
            for (GameObject card : repeatSas) {
                source.addRemembered(card);
                AbilityUtils.resolve(repeat);
                source.removeRemembered(card);
            }
        }
        if (sa.hasParam("RepeatTargeted")) {
            for (GameObject o : RepeatEachEffect.getTargets(sa)) {
                source.addRemembered(o);
                AbilityUtils.resolve(repeat);
                source.removeRemembered(o);
            }
        }
        if (sa.hasParam("RepeatTypesFrom")) {
            List<Card> res;
            HashSet<String> validTypes = new HashSet<String>();
            String def = sa.getParam("RepeatTypesFrom");
            if (def.startsWith("ThisTurnCast")) {
                String[] workingCopy = def.split("_");
                String validFilter = workingCopy[1];
                res = CardUtil.getThisTurnCast(validFilter, source, sa, activator);
            } else if (def.startsWith("Defined ")) {
                res = AbilityUtils.getDefinedCards(source, def.substring(8), sa);
            } else {
                ZoneType zone = sa.hasParam("TypesFromZone") ? ZoneType.smartValueOf(sa.getParam("TypesFromZone")) : ZoneType.Battlefield;
                res = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(zone), def, source.getController(), source, (CardTraitBase)sa);
            }
            for (Card c : res) {
                for (CardType.CoreType type : c.getType().getCoreTypes()) {
                    validTypes.add(type.name());
                }
            }
            String storedType = source.getChosenType();
            Player chooser = activator;
            if (sa.hasParam("ChooseOrder") && !sa.getParam("ChooseOrder").equals("True")) {
                chooser = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("ChooseOrder"), sa).get(false);
            }
            while (!validTypes.isEmpty()) {
                String chosenT = chooser.getController().chooseSomeType("card", sa, validTypes, null);
                source.setChosenType(chosenT);
                AbilityUtils.resolve(repeat);
                validTypes.remove(chosenT);
            }
            source.setChosenType(storedType);
        }
        if (sa.hasParam("RepeatPlayers")) {
            PlayerCollection repeatPlayers = RepeatEachEffect.getDefinedPlayersOrTargeted(sa, "RepeatPlayers");
            if (sa.hasParam("ClearRememberedBeforeLoop")) {
                source.clearRemembered();
            }
            boolean optional = sa.hasParam("RepeatOptionalForEachPlayer");
            boolean nextTurn = sa.hasParam("NextTurnForEachPlayer");
            for (Player p : repeatPlayers) {
                if (optional && !p.getController().confirmAction(repeat, null, sa.getParam("RepeatOptionalMessage"), null)) continue;
                if (nextTurn) {
                    game.getCleanup().addUntil(p, () -> {
                        ArrayList<Player> tempRemembered = Lists.newArrayList(Iterables.filter(source.getRemembered(), Player.class));
                        source.removeRemembered(tempRemembered);
                        source.addRemembered(p);
                        AbilityUtils.resolve(repeat);
                        source.removeRemembered(p);
                        source.addRemembered(tempRemembered);
                    });
                    continue;
                }
                ArrayList<Player> tempRemembered = Lists.newArrayList(Iterables.filter(source.getRemembered(), Player.class));
                source.removeRemembered(tempRemembered);
                source.addRemembered(p);
                if (sa.hasParam("AmountFromVotes")) {
                    this.setVoteAmount(p, sa);
                }
                AbilityUtils.resolve(repeat);
                source.removeRemembered(p);
                source.addRemembered(tempRemembered);
            }
        }
        if (sa.hasParam("DamageMap")) {
            game.getAction().dealDamage(false, sa.getDamageMap(), sa.getPreventMap(), sa.getCounterTable(), sa);
        }
        if (sa.hasParam("ChangeZoneTable")) {
            sa.getChangeZoneTable().triggerChangesZoneAll(game, sa);
            sa.setChangeZoneTable(null);
        }
        if (sa.hasParam("LoseLifeMap")) {
            Map<Player, Integer> lossMap = sa.getLoseLifeMap();
            if (!lossMap.isEmpty()) {
                Map<AbilityKey, Object> runParams2 = AbilityKey.mapFromPIMap(lossMap);
                game.getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runParams2, false);
            }
            sa.setLoseLifeMap(null);
        }
    }

    private void setVoteAmount(Object o, SpellAbility sa) {
        SpellAbility saVote;
        SpellAbility rootAbility = sa.getRootAbility();
        if (rootAbility.isWrapper()) {
            rootAbility = ((WrappedAbility)rootAbility).getWrappedAbility();
        }
        SpellAbility spellAbility = saVote = rootAbility.getApi().equals((Object)ApiType.Vote) ? rootAbility : rootAbility.findSubAbilityByType(ApiType.Vote);
        if (saVote == null) {
            System.err.println(sa.getHostCard() + ": Bad vote amount for " + o + ", default to 0");
            sa.setSVar("Votes", "Number$0");
        } else {
            sa.setSVar("Votes", saVote.getSVar("VoteNum" + o.toString()));
        }
    }
}

