/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.SpellAbilityEffect;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.MyRandom;
import java.util.Collections;

public class ReorderZoneEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        ZoneType zone = ZoneType.smartValueOf(sa.getParam("Zone"));
        PlayerCollection tgtPlayers = ReorderZoneEffect.getTargetPlayers(sa);
        boolean shuffle = sa.hasParam("Random");
        return "Reorder " + Lang.joinHomogenous(tgtPlayers) + " " + zone.toString() + " " + (shuffle ? "at random." : "as your choose.");
    }

    @Override
    public void resolve(SpellAbility sa) {
        ZoneType zone = ZoneType.smartValueOf(sa.getParam("Zone"));
        boolean shuffle = sa.hasParam("Random");
        for (Player p : ReorderZoneEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            CardCollection list = new CardCollection(p.getCardsIn(zone));
            if (shuffle) {
                Collections.shuffle(list, MyRandom.getRandom());
                p.getZone(zone).setCards(list);
                continue;
            }
            CardCollectionView orderedCards = p.getController().orderMoveToZoneList(list, zone, sa);
            p.getZone(zone).setCards(orderedCards);
        }
    }
}

