/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import java.util.Collection;

public class RegenerateEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = RegenerateEffect.getDefinedCardsOrTargeted(sa);
        if (!tgtCards.isEmpty()) {
            sb.append("Regenerate ");
            sb.append(Lang.joinHomogenous(tgtCards));
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Game game = sa.getHostCard().getGame();
        CardCollection result = new CardCollection();
        for (Card c : RegenerateEffect.getDefinedCardsOrTargeted(sa)) {
            Card gameCard;
            if (!c.isInPlay() || (gameCard = game.getCardState(c, null)) == null || !c.equalsWithGameTimestamp(gameCard)) continue;
            result.add(gameCard);
        }
        this.createRegenerationEffect(sa, result);
    }

    private void createRegenerationEffect(SpellAbility sa, Collection<Card> list) {
        if (list.isEmpty()) {
            return;
        }
        Card hostCard = sa.getHostCard();
        Game game = hostCard.getGame();
        Card eff = RegenerateEffect.createEffect(sa, sa.getActivatingPlayer(), hostCard + "'s Regeneration", hostCard.getImageKey());
        eff.addRemembered(list);
        RegenerateEffect.addForgetOnMovedTrigger(eff, "Battlefield");
        String repeffstr = "Event$ Destroy | ActiveZones$ Command | ValidCard$ Card.IsRemembered | Regeneration$ True | Description$ Regeneration (if creature would be destroyed, regenerate it instead)";
        String effect = "DB$ Regeneration | Defined$ ReplacedCard";
        String exileEff = "DB$ ChangeZone | Defined$ Self | Origin$ Command | Destination$ Exile | ConditionDefined$ Remembered | ConditionPresent$ Card | ConditionCompare$ EQ0";
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
        SpellAbility saReg = AbilityFactory.getAbility(effect, eff);
        AbilitySub saExile = (AbilitySub)AbilityFactory.getAbility(exileEff, eff);
        if (sa.hasAdditionalAbility("RegenerationAbility")) {
            AbilitySub trigSA = (AbilitySub)sa.getAdditionalAbility("RegenerationAbility").copy(eff, sa.getActivatingPlayer(), false);
            saExile.setSubAbility(trigSA);
        }
        saReg.setSubAbility(saExile);
        re.setOverridingAbility(saReg);
        eff.addReplacementEffect(re);
        if (sa.hasParam("RememberObjects")) {
            eff.addRemembered(AbilityUtils.getDefinedObjects(hostCard, sa.getParam("RememberObjects"), sa));
        }
        if (sa.isIntrinsic()) {
            eff.copyChangedTextFrom(hostCard);
        }
        for (Card c : list) {
            c.incShieldCount();
        }
        game.getAction().moveToCommand(eff, sa);
        game.getEndOfTurn().addUntil(RegenerateEffect.exileEffectCommand(game, eff));
    }
}

