/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class RadiationEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Player player = sa.getActivatingPlayer();
        Game game = host.getGame();
        int num = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Num", "0"), sa);
        GameEntityCounterTable table = new GameEntityCounterTable();
        for (Player p : RadiationEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            if (num >= 1) {
                p.addRadCounters(num, player, table);
                continue;
            }
            p.removeRadCounters(-num);
        }
        table.replaceCounterEffect(game, sa, true);
    }
}

