/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class PumpAllEffect
extends SpellAbilityEffect {
    private static void applyPumpAll(SpellAbility sa, Iterable<Card> list, int a, int d, List<String> keywords, List<ZoneType> affectedZones) {
        final Game game = sa.getActivatingPlayer().getGame();
        final long timestamp = game.getNextTimestamp();
        ArrayList<String> kws = Lists.newArrayList();
        ArrayList<String> hiddenkws = Lists.newArrayList();
        boolean perpetual = "Perpetual".equals(sa.getParam("Duration"));
        for (String kw : keywords) {
            if (kw.startsWith("HIDDEN")) {
                hiddenkws.add(kw.substring(7));
                continue;
            }
            kws.add(kw);
        }
        for (final Card tgtC : list) {
            HashMap<String, Object> params;
            if (!tgtC.isInZones(affectedZones)) continue;
            boolean redrawPT = false;
            if (a != 0 || d != 0) {
                if (perpetual) {
                    params = new HashMap<String, Object>();
                    params.put("Power", a);
                    params.put("Toughness", d);
                    params.put("Timestamp", timestamp);
                    params.put("Category", "PTBoost");
                    tgtC.addPerpetual(params);
                }
                tgtC.addPTBoost(a, d, timestamp, 0L);
                redrawPT = true;
            }
            if (!kws.isEmpty()) {
                if (perpetual) {
                    params = new HashMap();
                    params.put("AddKeywords", kws);
                    params.put("Timestamp", timestamp);
                    params.put("Category", "Keywords");
                    tgtC.addPerpetual(params);
                }
                tgtC.addChangedCardKeywords(kws, null, false, timestamp, null);
            }
            if (redrawPT) {
                tgtC.updatePowerToughnessForView();
            }
            if (!hiddenkws.isEmpty()) {
                tgtC.addHiddenExtrinsicKeywords(timestamp, 0L, hiddenkws);
            }
            if (sa.hasParam("RememberPumped")) {
                sa.getHostCard().addRemembered(tgtC);
            }
            if (!"Permanent".equals(sa.getParam("Duration")) && !perpetual) {
                GameCommand untilEOT = new GameCommand(){
                    private static final long serialVersionUID = 5415795460189457660L;

                    @Override
                    public void run() {
                        tgtC.removePTBoost(timestamp, 0L);
                        tgtC.removeChangedCardKeywords(timestamp, 0L);
                        tgtC.removeHiddenExtrinsicKeywords(timestamp, 0L);
                        tgtC.updatePowerToughnessForView();
                        game.fireEvent(new GameEventCardStatsChanged(tgtC));
                    }
                };
                PumpAllEffect.addUntilCommand(sa, untilEOT);
            }
            game.fireEvent(new GameEventCardStatsChanged(tgtC));
        }
        if (sa.hasParam("AtEOT") && !Iterables.isEmpty(list)) {
            PumpAllEffect.registerDelayedTrigger(sa, sa.getParam("AtEOT"), list);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String desc = "";
        if (sa.hasParam("SpellDescription")) {
            desc = sa.getParam("SpellDescription");
        }
        sb.append(desc);
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        CardCollectionView list;
        ArrayList<ZoneType> affectedZones = Lists.newArrayList();
        Game game = sa.getActivatingPlayer().getGame();
        if (!PumpAllEffect.checkValidDuration(sa.getParam("Duration"), sa)) {
            return;
        }
        if (sa.hasParam("PumpZone")) {
            affectedZones.addAll(ZoneType.listValueOf(sa.getParam("PumpZone")));
        } else {
            affectedZones.add(ZoneType.Battlefield);
        }
        if (!sa.usesTargeting() && !sa.hasParam("Defined")) {
            list = game.getCardsIn(affectedZones);
        } else {
            PlayerCollection tgtPlayers = PumpAllEffect.getTargetPlayers(sa);
            list = tgtPlayers.getCardsIn(affectedZones);
        }
        String valid = sa.getParamOrDefault("ValidCards", "");
        list = AbilityUtils.filterListByType(list, valid, sa);
        List<String> keywords = Lists.newArrayList();
        if (sa.hasParam("KW")) {
            keywords.addAll(Arrays.asList(sa.getParam("KW").split(" & ")));
        }
        int a = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumAtt"), sa, true);
        int d = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumDef"), sa, true);
        if (sa.hasParam("SharedKeywordsZone")) {
            List<ZoneType> zones = ZoneType.listValueOf(sa.getParam("SharedKeywordsZone"));
            String[] restrictions = new String[]{"Card"};
            if (sa.hasParam("SharedRestrictions")) {
                restrictions = sa.getParam("SharedRestrictions").split(",");
            }
            keywords = CardFactoryUtil.sharedKeywords(keywords, restrictions, zones, sa.getHostCard(), sa);
        }
        PumpAllEffect.applyPumpAll(sa, list, a, d, keywords, affectedZones);
        PumpAllEffect.replaceDying(sa);
    }
}

