/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.card.CardType;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardUtil;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ProtectEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        List<String> gains = ProtectEffect.getProtectionList(sa);
        boolean choose = sa.hasParam("Choices");
        String joiner = choose ? "or" : "and";
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = ProtectEffect.getTargetCards(sa);
        if (!tgtCards.isEmpty()) {
            Iterator it = tgtCards.iterator();
            while (it.hasNext()) {
                Card tgtC = (Card)it.next();
                if (tgtC.isFaceDown()) {
                    sb.append("Morph");
                } else {
                    sb.append(tgtC);
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            if (sa.hasParam("Radiance") && sa.usesTargeting()) {
                sb.append(" and each other ").append(sa.getParam("ValidTgts")).append(" that shares a color with ");
                if (tgtCards.size() > 1) {
                    sb.append("them");
                } else {
                    sb.append("it");
                }
            }
            sb.append(" gain");
            if (tgtCards.size() == 1) {
                sb.append("s");
            }
            sb.append(" protection from ");
            if (choose) {
                sb.append("your choice of ");
            }
            for (int i = 0; i < gains.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                if (i == gains.size() - 1) {
                    sb.append(joiner).append(" ");
                }
                sb.append(gains.get(i));
            }
            if (!"Permanent".equals(sa.getParam("Duration"))) {
                sb.append(" until end of turn");
            }
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = sa.getActivatingPlayer().getGame();
        boolean isChoice = sa.getParam("Gains").contains("Choice");
        List<String> choices = ProtectEffect.getProtectionList(sa);
        ArrayList<String> gains = new ArrayList<String>();
        CardCollection tgtCards = ProtectEffect.getTargetCards(sa);
        if (isChoice && !choices.isEmpty()) {
            String string;
            Object choser = sa.getActivatingPlayer();
            if (sa.hasParam("Choser") && sa.getParam("Choser").equals("Controller") && !tgtCards.isEmpty()) {
                choser = ((Card)tgtCards.get(0)).getController();
            }
            if (null == (string = ((Player)choser).getController().chooseProtectionType(Localizer.getInstance().getMessage("lblChooseAProtection", new Object[0]), sa, choices))) {
                return;
            }
            gains.add(string);
            game.getAction().notifyOfValue(sa, (GameObject)choser, Lang.joinHomogenous(gains), (Player)choser);
        } else if (sa.getParam("Gains").equals("ChosenColor")) {
            for (String string : host.getChosenColors()) {
                gains.add(string.toLowerCase());
            }
        } else if (sa.getParam("Gains").startsWith("Defined")) {
            CardCollection def = AbilityUtils.getDefinedCards(host, sa.getParam("Gains").substring(8), sa);
            for (Byte color : ((Card)def.get(false)).getColor()) {
                gains.add(MagicColor.toLongString(color));
            }
        } else {
            gains.addAll(choices);
        }
        ArrayList<String> gainsKWList = Lists.newArrayList();
        for (String type : gains) {
            if (CardType.isACardType(type)) {
                gainsKWList.add("Protection:" + type);
                continue;
            }
            gainsKWList.add(TextUtil.concatWithSpace("Protection from", type));
        }
        tgtCards.addAll(CardUtil.getRadiance(sa));
        final long l = game.getNextTimestamp();
        for (final Card tgtC : tgtCards) {
            if (!tgtC.isInPlay() || tgtC.isPhasedOut()) continue;
            tgtC.addChangedCardKeywords(gainsKWList, null, false, l, null, true);
            if ("Permanent".equals(sa.getParam("Duration"))) continue;
            GameCommand untilEOT = new GameCommand(){
                private static final long serialVersionUID = 7682700789217703789L;

                @Override
                public void run() {
                    if (tgtC.isInPlay()) {
                        tgtC.removeChangedCardKeywords(l, 0L, true);
                    }
                }
            };
            ProtectEffect.addUntilCommand(sa, untilEOT);
        }
    }

    public static List<String> getProtectionList(SpellAbility sa) {
        ArrayList<String> gains = new ArrayList<String>();
        String gainStr = sa.getParam("Gains");
        if (gainStr.equals("Choice")) {
            String choices = sa.getParam("Choices");
            if (choices.contains("AnyColor")) {
                gains.addAll(MagicColor.Constant.ONLY_COLORS);
                choices = choices.replaceAll("AnyColor,?", "");
            } else if (choices.contains("CardType")) {
                choices = StringUtils.join(CardType.getAllCardTypes(), ",");
            }
            if (choices.length() > 0) {
                gains.addAll(Arrays.asList(choices.split(",")));
            }
        } else {
            gains.addAll(Arrays.asList(gainStr.split(",")));
        }
        return gains;
    }
}

