/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.ability.effects.ProtectEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.List;

public class ProtectAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = ProtectAllEffect.getTargetCards(sa);
        if (tgtCards.size() > 0) {
            sb.append("Valid card gain protection");
            if (!"Permanent".equals(sa.getParam("Duration"))) {
                sb.append(" until end of turn");
            }
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        String players;
        Object object;
        Card host = sa.getHostCard();
        Game game = sa.getActivatingPlayer().getGame();
        final long timestamp = game.getNextTimestamp();
        boolean isChoice = sa.getParam("Gains").contains("Choice");
        List<String> choices = ProtectEffect.getProtectionList(sa);
        ArrayList<String> gains = new ArrayList<String>();
        if (isChoice) {
            Player choser = sa.getActivatingPlayer();
            String choice = choser.getController().chooseProtectionType(Localizer.getInstance().getMessage("lblChooseAProtection", new Object[0]), sa, choices);
            if (null == choice) {
                return;
            }
            gains.add(choice);
            game.getAction().notifyOfValue(sa, choser, Lang.joinHomogenous(gains), choser);
        } else if (sa.getParam("Gains").equals("ChosenColor")) {
            for (String color : host.getChosenColors()) {
                gains.add(color.toLowerCase());
            }
        } else if (sa.getParam("Gains").equals("TargetedCardColor")) {
            for (Object c : sa.getSATargetingCard().getTargets().getTargetCards()) {
                ColorSet cs = ((Card)c).getColor();
                for (byte col : MagicColor.WUBRG) {
                    if (!cs.hasAnyColor(col)) continue;
                    gains.add(MagicColor.toLongString(col).toLowerCase());
                }
            }
        } else {
            gains.addAll(choices);
        }
        ArrayList<String> gainsKWList = Lists.newArrayList();
        for (String color : gains) {
            gainsKWList.add(TextUtil.concatWithSpace("Protection from", color));
        }
        String valid = sa.getParamOrDefault("ValidCards", "");
        if (!valid.isEmpty()) {
            CardCollection list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), valid, sa.getActivatingPlayer(), host, (CardTraitBase)sa);
            object = list.iterator();
            while (object.hasNext()) {
                final Card tgtC = (Card)object.next();
                tgtC.addChangedCardKeywords(gainsKWList, null, false, timestamp, null, true);
                if ("Permanent".equals(sa.getParam("Duration"))) continue;
                GameCommand untilEOT = new GameCommand(){
                    private static final long serialVersionUID = -6573962672873853565L;

                    @Override
                    public void run() {
                        if (tgtC.isInPlay()) {
                            tgtC.removeChangedCardKeywords(timestamp, 0L, true);
                        }
                    }
                };
                ProtectAllEffect.addUntilCommand(sa, untilEOT);
            }
        }
        if (!(players = sa.getParamOrDefault("ValidPlayers", "")).isEmpty()) {
            object = AbilityUtils.getDefinedPlayers(host, players, sa).iterator();
            while (object.hasNext()) {
                final Player player = (Player)object.next();
                player.addChangedKeywords(gainsKWList, ImmutableList.of(), timestamp, 0L);
                if ("Permanent".equals(sa.getParam("Duration"))) continue;
                GameCommand revokeCommand = new GameCommand(){
                    private static final long serialVersionUID = -6573962672873853565L;

                    @Override
                    public void run() {
                        player.removeChangedKeywords(timestamp, 0L);
                    }
                };
                ProtectAllEffect.addUntilCommand(sa, revokeCommand);
            }
        }
    }
}

