/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardZoneTable;
import forge.game.spellability.SpellAbility;
import java.util.Collections;
import java.util.EnumMap;

public class PermanentEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable table = AbilityKey.addCardZoneTableParams(moveParams, sa);
        Card c = game.getAction().moveToPlay(host, host.getController(), sa, moveParams);
        sa.setHostCard(c);
        if (sa.isDash() && c.isInPlay()) {
            c.addChangedSVars(Collections.singletonMap("EndOfTurnLeavePlay", "Dash"), c.getGame().getNextTimestamp(), 0L);
            PermanentEffect.registerDelayedTrigger(sa, "Hand", Lists.newArrayList(c));
        }
        if (sa.isBlitz() && c.isInPlay()) {
            c.addChangedSVars(Collections.singletonMap("EndOfTurnLeavePlay", "Blitz"), c.getGame().getNextTimestamp(), 0L);
            PermanentEffect.registerDelayedTrigger(sa, "Sacrifice", Lists.newArrayList(c));
        }
        table.triggerChangesZoneAll(game, sa);
    }
}

