/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.card.GamePieceType;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactory;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.HashMap;

public class MutateEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        boolean putOnTop;
        Card host = sa.getHostCard();
        Player p = host.getOwner();
        Game game = host.getGame();
        if (host.isCopiedSpell()) {
            host.setGamePieceType(GamePieceType.TOKEN);
        }
        Card target = (Card)MutateEffect.getDefinedCardsOrTargeted(sa, "Defined").get(false);
        CardCollectionView view = CardCollection.getView(Lists.newArrayList(host, target));
        Card topCard = host.getController().getController().chooseSingleEntityForEffect(view, sa, Localizer.getInstance().getMessage("lblChooseCreatureToBeTop", new Object[0]), false, new HashMap<String, Object>());
        boolean bl = putOnTop = topCard == host;
        if (sa.isSpell()) {
            host.setController(p, 0L);
        }
        boolean wasFaceDown = target.isFaceDown();
        host.setMergedToCard(target);
        if (!target.hasMergedCard()) {
            target.addMergedCard(target);
        }
        if (putOnTop) {
            target.addMergedCardToTop(host);
        } else {
            target.addMergedCard(host);
        }
        target.removeMutatedStates();
        long ts = game.getNextTimestamp();
        target.setMutatedTimestamp(ts);
        target.addCloneState(CardFactory.getMutatedCloneStates(target, sa), ts);
        if (wasFaceDown && !target.isFaceDown()) {
            target.runFaceupCommands();
        }
        game.getTriggerHandler().clearActiveTriggers(target, null);
        game.getTriggerHandler().registerActiveTrigger(target, false);
        game.getAction().moveTo(p.getZone(ZoneType.Merged), host, sa, AbilityKey.newMap());
        host.setTapped(target.isTapped());
        host.setFlipped(target.isFlipped());
        target.setTimesMutated(target.getTimesMutated() + 1);
        target.updateStateForView();
        target.updateTokenView();
        if (host.isCommander()) {
            host.getOwner().updateMergedCommanderInfo(target, host);
            target.updateCommanderView();
        }
        game.getTriggerHandler().runTrigger(TriggerType.Mutates, AbilityKey.mapFromCard(target), false);
    }
}

